/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.decl.CSSDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSExpression;
import vuegwt.shaded.com.helger.css.decl.ICSSSupportsConditionMember;

@NotThreadSafe
public class CSSSupportsConditionDeclaration
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final CSSDeclaration m_aDeclaration;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSupportsConditionDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        this(new CSSDeclaration(string, cSSExpression));
    }

    public CSSSupportsConditionDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclaration = ValueEnforcer.notNull(cSSDeclaration, "Declaration");
    }

    @Nonnull
    public CSSDeclaration getDeclaration() {
        return this.m_aDeclaration;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return "(" + this.m_aDeclaration.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = (CSSSupportsConditionDeclaration)object;
        return this.m_aDeclaration.equals(cSSSupportsConditionDeclaration.m_aDeclaration);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aDeclaration).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("declaration", this.m_aDeclaration).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

