/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.state.EChange;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.CSSSourceLocation;
import vuegwt.shaded.com.helger.css.ICSSSourceLocationAware;
import vuegwt.shaded.com.helger.css.decl.AbstractHasTopLevelRules;
import vuegwt.shaded.com.helger.css.decl.CSSImportRule;
import vuegwt.shaded.com.helger.css.decl.CSSNamespaceRule;

@NotThreadSafe
public class CascadingStyleSheet
extends AbstractHasTopLevelRules
implements ICSSSourceLocationAware {
    private final ICommonsList<CSSImportRule> m_aImportRules = new CommonsArrayList<CSSImportRule>();
    private final ICommonsList<CSSNamespaceRule> m_aNamespaceRules = new CommonsArrayList<CSSNamespaceRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return this.m_aImportRules.isNotEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int n) {
        return (CSSImportRule)this.m_aImportRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.notNull(cSSImportRule, "ImportRule");
        this.m_aImportRules.add(cSSImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int n, @Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(cSSImportRule, "ImportRule");
        if (n >= this.getImportRuleCount()) {
            this.m_aImportRules.add(cSSImportRule);
        } else {
            this.m_aImportRules.add(n, cSSImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule cSSImportRule) {
        return this.m_aImportRules.removeObject(cSSImportRule);
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int n) {
        return this.m_aImportRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllImportRules() {
        return this.m_aImportRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSImportRule> getAllImportRules() {
        return (ICommonsList)this.m_aImportRules.getClone();
    }

    public boolean hasNamespaceRules() {
        return this.m_aNamespaceRules.isNotEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int n) {
        return (CSSNamespaceRule)this.m_aNamespaceRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.notNull(cSSNamespaceRule, "NamespaceRule");
        this.m_aNamespaceRules.add(cSSNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int n, @Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.isGE0(n, "Index");
        ValueEnforcer.notNull(cSSNamespaceRule, "NamespaceRule");
        if (n >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add(cSSNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(n, cSSNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule cSSNamespaceRule) {
        return this.m_aNamespaceRules.removeObject(cSSNamespaceRule);
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int n) {
        return this.m_aNamespaceRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        return this.m_aNamespaceRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSNamespaceRule> getAllNamespaceRules() {
        return (ICommonsList)this.m_aNamespaceRules.getClone();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CascadingStyleSheet cascadingStyleSheet = (CascadingStyleSheet)object;
        return this.m_aImportRules.equals(cascadingStyleSheet.m_aImportRules) && this.m_aNamespaceRules.equals(cascadingStyleSheet.m_aNamespaceRules) && this.m_aRules.equals(cascadingStyleSheet.m_aRules);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aImportRules)).append(this.m_aNamespaceRules)).append((Iterable)this.m_aRules)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", this.m_aSourceLocation).getToString();
    }
}

