/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl.shorthand;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsHashMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsSet;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.css.ECSSUnit;
import vuegwt.shaded.com.helger.css.decl.shorthand.CSSPropertyWithDefaultValue;
import vuegwt.shaded.com.helger.css.decl.shorthand.CSSShortHandDescriptor;
import vuegwt.shaded.com.helger.css.decl.shorthand.CSSShortHandDescriptorWithAlignment;
import vuegwt.shaded.com.helger.css.property.CCSSProperties;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;
import vuegwt.shaded.com.helger.css.utils.ECSSColor;

@ThreadSafe
public final class CSSShortHandRegistry {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<ECSSProperty, CSSShortHandDescriptor> s_aMap = new CommonsHashMap<ECSSProperty, CSSShortHandDescriptor>();

    private CSSShortHandRegistry() {
    }

    public static void registerShortHandDescriptor(@Nonnull CSSShortHandDescriptor cSSShortHandDescriptor) {
        ValueEnforcer.notNull(cSSShortHandDescriptor, "Descriptor");
        ECSSProperty eCSSProperty = cSSShortHandDescriptor.getProperty();
        s_aRWLock.writeLocked(() -> {
            if (s_aMap.containsKey(eCSSProperty)) {
                throw new IllegalStateException("A short hand for property '" + eCSSProperty.getName() + "' is already registered!");
            }
            s_aMap.put(eCSSProperty, cSSShortHandDescriptor);
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<ECSSProperty> getAllShortHandProperties() {
        return s_aRWLock.readLocked(() -> s_aMap.copyOfKeySet());
    }

    public static boolean isShortHandProperty(@Nullable ECSSProperty eCSSProperty) {
        if (eCSSProperty == null) {
            return false;
        }
        return s_aRWLock.readLocked(() -> s_aMap.containsKey(eCSSProperty));
    }

    @Nullable
    public static CSSShortHandDescriptor getShortHandDescriptor(@Nullable ECSSProperty eCSSProperty) {
        if (eCSSProperty == null) {
            return null;
        }
        return s_aRWLock.readLocked(() -> (CSSShortHandDescriptor)s_aMap.get(eCSSProperty));
    }

    static {
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BACKGROUND, new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_COLOR, "transparent"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_IMAGE, "none"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_REPEAT, "repeat"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_POSITION, "top left"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ATTACHMENT, "scroll"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_CLIP, "border-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ORIGIN, "padding-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_SIZE, "auto auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.FONT, new CSSPropertyWithDefaultValue(CCSSProperties.FONT_STYLE, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_VARIANT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_WEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_SIZE, "inherit"), new CSSPropertyWithDefaultValue(CCSSProperties.LINE_HEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_FAMILY, "inherit")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_TOP, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_RIGHT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_BOTTOM, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_LEFT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_WIDTH, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3))));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.BORDER_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.BORDER_COLOR, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.MARGIN, new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.PADDING, new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.OUTLINE, new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.LIST_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_TYPE, "disc"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_POSITION, "outside"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_IMAGE, "none")));
    }
}

