/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.decl.visit;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.collection.NonBlockingStack;
import vuegwt.shaded.com.helger.css.decl.CSSDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSExpression;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberTermURI;
import vuegwt.shaded.com.helger.css.decl.CSSFontFaceRule;
import vuegwt.shaded.com.helger.css.decl.CSSImportRule;
import vuegwt.shaded.com.helger.css.decl.CSSKeyframesBlock;
import vuegwt.shaded.com.helger.css.decl.CSSKeyframesRule;
import vuegwt.shaded.com.helger.css.decl.CSSMediaRule;
import vuegwt.shaded.com.helger.css.decl.CSSNamespaceRule;
import vuegwt.shaded.com.helger.css.decl.CSSPageMarginBlock;
import vuegwt.shaded.com.helger.css.decl.CSSPageRule;
import vuegwt.shaded.com.helger.css.decl.CSSSelector;
import vuegwt.shaded.com.helger.css.decl.CSSStyleRule;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsRule;
import vuegwt.shaded.com.helger.css.decl.CSSUnknownRule;
import vuegwt.shaded.com.helger.css.decl.CSSViewportRule;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMember;
import vuegwt.shaded.com.helger.css.decl.ICSSTopLevelRule;
import vuegwt.shaded.com.helger.css.decl.visit.ICSSUrlVisitor;
import vuegwt.shaded.com.helger.css.decl.visit.ICSSVisitor;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        this.m_aVisitor = ValueEnforcer.notNull(iCSSUrlVisitor, "Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        ICSSTopLevelRule iCSSTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : this.m_aTopLevelRule.peek();
        CSSExpression cSSExpression = cSSDeclaration.getExpression();
        for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
            if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)iCSSExpressionMember;
            this.m_aVisitor.onUrlDeclaration(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberTermURI);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.push(cSSStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector cSSSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.push(cSSPageRule);
    }

    @Override
    public void onBeginPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.push(cSSFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.push(cSSMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.push(cSSKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.push(cSSViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.push(cSSSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule cSSUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

