/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.handler;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CSSDeclarationList;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.handler.CSSHandlingException;
import vuegwt.shaded.com.helger.css.handler.CSSNodeToDomainObject;
import vuegwt.shaded.com.helger.css.handler.ECSSNodeType;
import vuegwt.shaded.com.helger.css.parser.CSSNode;
import vuegwt.shaded.com.helger.css.reader.CSSReader;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;

@Immutable
public final class CSSHandler {
    private static final CSSHandler s_aInstance = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode, CSSReader.getDefaultInterpretErrorHandler());
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull(eCSSVersion, "Version");
        ValueEnforcer.notNull(cSSNode, "Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    @Deprecated
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readDeclarationListFromNode(eCSSVersion, cSSNode, CSSReader.getDefaultInterpretErrorHandler());
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull(eCSSVersion, "Version");
        ValueEnforcer.notNull(cSSNode, "Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler).createDeclarationListFromNode(cSSNode);
    }
}

