/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CSSDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSDeclarationList;
import vuegwt.shaded.com.helger.css.decl.CSSExpression;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberFunction;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberLineNames;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberMath;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberMathProduct;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberMathUnitSimple;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberTermSimple;
import vuegwt.shaded.com.helger.css.decl.CSSExpressionMemberTermURI;
import vuegwt.shaded.com.helger.css.decl.CSSFontFaceRule;
import vuegwt.shaded.com.helger.css.decl.CSSImportRule;
import vuegwt.shaded.com.helger.css.decl.CSSKeyframesBlock;
import vuegwt.shaded.com.helger.css.decl.CSSKeyframesRule;
import vuegwt.shaded.com.helger.css.decl.CSSMediaExpression;
import vuegwt.shaded.com.helger.css.decl.CSSMediaQuery;
import vuegwt.shaded.com.helger.css.decl.CSSMediaRule;
import vuegwt.shaded.com.helger.css.decl.CSSNamespaceRule;
import vuegwt.shaded.com.helger.css.decl.CSSPageMarginBlock;
import vuegwt.shaded.com.helger.css.decl.CSSPageRule;
import vuegwt.shaded.com.helger.css.decl.CSSSelector;
import vuegwt.shaded.com.helger.css.decl.CSSSelectorAttribute;
import vuegwt.shaded.com.helger.css.decl.CSSSelectorMemberFunctionLike;
import vuegwt.shaded.com.helger.css.decl.CSSSelectorMemberNot;
import vuegwt.shaded.com.helger.css.decl.CSSSelectorSimpleMember;
import vuegwt.shaded.com.helger.css.decl.CSSStyleRule;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsConditionDeclaration;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsConditionNegation;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsConditionNested;
import vuegwt.shaded.com.helger.css.decl.CSSSupportsRule;
import vuegwt.shaded.com.helger.css.decl.CSSURI;
import vuegwt.shaded.com.helger.css.decl.CSSUnknownRule;
import vuegwt.shaded.com.helger.css.decl.CSSViewportRule;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.decl.ECSSAttributeOperator;
import vuegwt.shaded.com.helger.css.decl.ECSSExpressionOperator;
import vuegwt.shaded.com.helger.css.decl.ECSSMathOperator;
import vuegwt.shaded.com.helger.css.decl.ECSSSelectorCombinator;
import vuegwt.shaded.com.helger.css.decl.ECSSSupportsConditionOperator;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMathMember;
import vuegwt.shaded.com.helger.css.decl.ICSSExpressionMember;
import vuegwt.shaded.com.helger.css.decl.ICSSPageRuleMember;
import vuegwt.shaded.com.helger.css.decl.ICSSSelectorMember;
import vuegwt.shaded.com.helger.css.decl.ICSSSupportsConditionMember;
import vuegwt.shaded.com.helger.css.handler.CSSHandlingException;
import vuegwt.shaded.com.helger.css.handler.ECSSNodeType;
import vuegwt.shaded.com.helger.css.media.ECSSMediaExpressionFeature;
import vuegwt.shaded.com.helger.css.media.ECSSMedium;
import vuegwt.shaded.com.helger.css.parser.CSSNode;
import vuegwt.shaded.com.helger.css.parser.CSSParseHelper;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private final ECSSVersion m_eVersion;
    private final ICSSInterpretErrorHandler m_aErrorHandler;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        this.m_eVersion = ValueEnforcer.notNull(eCSSVersion, "Version");
        this.m_aErrorHandler = ValueEnforcer.notNull(iCSSInterpretErrorHandler, "ErrorHandler");
    }

    private void _expectNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSNodeType eCSSNodeType) {
        if (!eCSSNodeType.isNode(cSSNode, this.m_eVersion)) {
            throw new CSSHandlingException(cSSNode, "Expected a '" + eCSSNodeType.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + "'");
        }
    }

    private void _throwUnexpectedChildrenCount(@Nonnull CSSNode cSSNode, @Nonnull @Nonempty String string) {
        this.m_aErrorHandler.onCSSInterpretationError(string);
        for (int i = 0; i < cSSNode.jjtGetNumChildren(); ++i) {
            this.m_aErrorHandler.onCSSInterpretationError("  " + cSSNode.jjtGetChild(i));
        }
        throw new CSSHandlingException(cSSNode, string);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.IMPORTRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at last 2 children but got " + n + "!");
        }
        CSSURI cSSURI = null;
        int n2 = 0;
        if (n > 0) {
            serializable = cSSNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode((CSSNode)serializable, this.m_eVersion)) {
                cSSURI = new CSSURI(((CSSNode)serializable).getText());
                cSSURI.setSourceLocation(((CSSNode)serializable).getSourceLocation());
                ++n2;
            } else if (!ECSSNodeType.MEDIALIST.isNode((CSSNode)serializable, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName((CSSNode)serializable, this.m_eVersion));
            }
        }
        if (cSSURI == null) {
            cSSURI = new CSSURI(CSSParseHelper.extractStringValue(cSSNode.getText()));
        }
        serializable = new CSSImportRule(cSSURI);
        ((CSSImportRule)serializable).setSourceLocation(cSSNode.getSourceLocation());
        if (n > n2) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ((CSSImportRule)serializable).addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                ++n2;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            }
        }
        if (n2 < n) {
            this.m_aErrorHandler.onCSSInterpretationError("Import statement has children which are unhandled.");
        }
        return serializable;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode cSSNode) {
        CSSSelectorAttribute cSSSelectorAttribute;
        this._expectNodeType(cSSNode, ECSSNodeType.ATTRIB);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            n2 = 1;
        }
        String string2 = cSSNode.getText();
        if (n == n2) {
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2);
        } else {
            int n3 = n2 + 2;
            if (n != n3) {
                this._throwUnexpectedChildrenCount(cSSNode, "Illegal number of children present (" + n + ") - expected " + n3);
            }
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            this._expectNodeType(cSSNode2, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n2 + 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.ATTRIBVALUE);
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2, ECSSAttributeOperator.getFromNameOrNull(cSSNode2.getText()), cSSNode3.getText());
        }
        cSSSelectorAttribute.setSourceLocation(cSSNode.getSourceLocation());
        return cSSSelectorAttribute;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "CSS simple selector member expected 0 children and got " + n);
            }
            CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
            cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorSimpleMember;
        }
        if (ECSSNodeType.ATTRIB.isNode(cSSNode, this.m_eVersion)) {
            return this._createSelectorAttribute(cSSNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            ECSSSelectorCombinator eCSSSelectorCombinator = ECSSSelectorCombinator.getFromNameOrNull(string);
            if (eCSSSelectorCombinator == null) {
                this.m_aErrorHandler.onCSSInterpretationError("Failed to parse CSS selector combinator '" + string + "'");
            }
            return eCSSSelectorCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(cSSNode, this.m_eVersion)) {
            CommonsArrayList<CSSSelector> commonsArrayList = new CommonsArrayList<CSSSelector>();
            for (int i = 0; i < n; ++i) {
                CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
                CSSSelector cSSSelector = this._createSelector(cSSNode2);
                commonsArrayList.add(cSSSelector);
            }
            CSSSelectorMemberNot cSSSelectorMemberNot = new CSSSelectorMemberNot(commonsArrayList);
            cSSSelectorMemberNot.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorMemberNot;
        }
        if (ECSSNodeType.PSEUDO.isNode(cSSNode, this.m_eVersion)) {
            if (n == 0) {
                CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
                cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorSimpleMember;
            }
            if (n == 1) {
                CSSNode cSSNode3 = cSSNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText() + cSSNode3.getText() + ")");
                    cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                    return cSSSelectorSimpleMember;
                }
                CSSExpression cSSExpression = this._createExpression(cSSNode3);
                CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = new CSSSelectorMemberFunctionLike(cSSNode.getText(), cSSExpression);
                cSSSelectorMemberFunctionLike.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorMemberFunctionLike;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + n + " args: " + cSSNode.toString());
        }
        this.m_aErrorHandler.onCSSInterpretationError("Unsupported selector child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATHPRODUCT);
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = new CSSExpressionMemberMathProduct();
        cSSExpressionMemberMathProduct.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSExpressionMathMember iCSSExpressionMathMember;
            if (ECSSNodeType.MATHUNIT.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                if (n == 0) {
                    iCSSExpressionMathMember = new CSSExpressionMemberMathUnitSimple(cSSNode2.getText());
                    ((CSSExpressionMemberMathUnitSimple)iCSSExpressionMathMember).setSourceLocation(cSSNode2.getSourceLocation());
                    cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                    continue;
                }
                if (n == 1 && ECSSNodeType.FUNCTION.isNode(cSSNode2.jjtGetChild(0), this.m_eVersion)) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionFunction(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n == 1 && ECSSNodeType.MATH.isNode(cSSNode2.jjtGetChild(0), this.m_eVersion)) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionCalc(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n % 2 == 0) {
                    this._throwUnexpectedChildrenCount(cSSNode2, "CSS math unit expected odd child count and got " + n);
                }
                iCSSExpressionMathMember = new CSSExpressionMemberMathProduct();
                for (int i = 0; i < n; ++i) {
                    CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                    if (ECSSNodeType.MATHPRODUCT.isNode(cSSNode3, this.m_eVersion)) {
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(this._createExpressionMathProduct(cSSNode3));
                        continue;
                    }
                    if (ECSSNodeType.MATHSUMOPERATOR.isNode(cSSNode3, this.m_eVersion)) {
                        String string = cSSNode3.getText();
                        ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                        if (eCSSMathOperator == null) {
                            this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                            continue;
                        }
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(eCSSMathOperator);
                        continue;
                    }
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
                }
                cSSExpressionMemberMathProduct.addMember(new CSSExpressionMemberMathUnitProduct((CSSExpressionMemberMathProduct)iCSSExpressionMathMember));
                continue;
            }
            if (ECSSNodeType.MATHPRODUCTOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                iCSSExpressionMathMember = ECSSMathOperator.getFromNameOrNull(string);
                if (iCSSExpressionMathMember == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math product operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMathProduct;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.URL);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 children but got " + n + "!");
        }
        CSSURI cSSURI = new CSSURI(cSSNode.getText());
        cSSURI.setSourceLocation(cSSNode.getSourceLocation());
        return new CSSExpressionMemberTermURI(cSSURI);
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode cSSNode) {
        CSSExpressionMemberFunction cSSExpressionMemberFunction;
        this._expectNodeType(cSSNode, ECSSNodeType.FUNCTION);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        String string = cSSNode.getText();
        if (n == 1) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
            CSSExpression cSSExpression = this._createExpression(cSSNode2);
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string, cSSExpression);
        } else {
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string);
        }
        cSSExpressionMemberFunction.setSourceLocation(cSSNode.getSourceLocation());
        return cSSExpressionMemberFunction;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionCalc(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath cSSExpressionMemberMath = new CSSExpressionMemberMath();
        cSSExpressionMemberMath.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MATHPRODUCT.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberMath.addMember(this._createExpressionMathProduct(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MATHSUMOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                if (eCSSMathOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMath.addMember(eCSSMathOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMath;
    }

    @Nonnull
    private CSSExpressionMemberLineNames _createExpressionLineNamesTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.LINE_NAMES);
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = new CSSExpressionMemberLineNames();
        cSSExpressionMemberLineNames.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.LINE_NAME.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberLineNames.addMember(cSSNode2.getText());
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberLineNames;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPRTERM);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        if (n == 0) {
            CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = new CSSExpressionMemberTermSimple(cSSNode.getText());
            cSSExpressionMemberTermSimple.setSourceLocation(cSSNode.getSourceLocation());
            return cSSExpressionMemberTermSimple;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionURL(cSSNode2);
        }
        if (ECSSNodeType.FUNCTION.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionFunction(cSSNode2);
        }
        if (ECSSNodeType.MATH.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionCalc(cSSNode2);
        }
        if (ECSSNodeType.LINE_NAMES.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionLineNamesTerm(cSSNode2);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPR);
        CSSExpression cSSExpression = new CSSExpression();
        cSSExpression.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.EXPRTERM.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpression.addMember(this._createExpressionTerm(cSSNode2));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSExpressionOperator eCSSExpressionOperator = ECSSExpressionOperator.getFromNameOrNull(string);
                if (eCSSExpressionOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse expression operator '" + string + "'");
                    continue;
                }
                cSSExpression.addMember(eCSSExpressionOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpression;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATION);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 3) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1-3 children but got " + n + "!");
        }
        if (n == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(cSSNode.jjtGetChild(1), this.m_eVersion)) {
            return null;
        }
        String string = cSSNode.jjtGetChild(0).getText();
        CSSExpression cSSExpression = this._createExpression(cSSNode.jjtGetChild(1));
        boolean bl = false;
        if (n == 3) {
            serializable = cSSNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode((CSSNode)serializable, this.m_eVersion)) {
                bl = true;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName((CSSNode)serializable, this.m_eVersion));
            }
        }
        serializable = new CSSDeclaration(string, cSSExpression, bl);
        ((CSSDeclaration)serializable).setSourceLocation(cSSNode.getSourceLocation());
        return serializable;
    }

    private void _readStyleDeclarationList(@Nonnull CSSNode cSSNode, @Nonnull Consumer<CSSDeclaration> consumer) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATIONLIST);
        int n = cSSNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            CSSDeclaration cSSDeclaration;
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (!ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2, this.m_eVersion) || (cSSDeclaration = this._createDeclaration(cSSNode2)) == null) continue;
            consumer.accept(cSSDeclaration);
        }
    }

    @Nullable
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLERULE);
        CSSStyleRule cSSStyleRule = new CSSStyleRule();
        cSSStyleRule.setSourceLocation(cSSNode.getSourceLocation());
        boolean bl = true;
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SELECTOR.isNode(cSSNode2, this.m_eVersion)) {
                if (!bl) {
                    this.m_aErrorHandler.onCSSInterpretationError("Found a selector after a declaration!");
                }
                cSSStyleRule.addSelector(this._createSelector(cSSNode2));
                continue;
            }
            bl = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSDeclaration -> cSSStyleRule.addDeclaration((CSSDeclaration)cSSDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        if (cSSStyleRule.getSelectorCount() == 0) {
            return null;
        }
        return cSSStyleRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.PAGERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (this.m_eVersion == ECSSVersion.CSS30) {
            CSSNode cSSNode2;
            if (n < 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
            }
            CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
            for (int i = 0; i < n - 1; ++i) {
                cSSNode2 = cSSNode.jjtGetChild(i);
                this._expectNodeType(cSSNode2, ECSSNodeType.PAGESELECTOR);
                commonsArrayList.add(cSSNode2.getText());
            }
            CSSPageRule cSSPageRule = new CSSPageRule(commonsArrayList);
            cSSPageRule.setSourceLocation(cSSNode.getSourceLocation());
            cSSNode2 = cSSNode.jjtGetChild(n - 1);
            this._expectNodeType(cSSNode2, ECSSNodeType.PAGERULEBLOCK);
            int n2 = cSSNode2.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                ICSSPageRuleMember iCSSPageRuleMember;
                CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode3, this.m_eVersion)) {
                    iCSSPageRuleMember = this._createDeclaration(cSSNode3);
                    if (iCSSPageRuleMember == null) continue;
                    cSSPageRule.addMember(iCSSPageRuleMember);
                    continue;
                }
                if (ECSSNodeType.PAGEMARGINSYMBOL.isNode(cSSNode3, this.m_eVersion)) {
                    iCSSPageRuleMember = new CSSPageMarginBlock(cSSNode3.getText());
                    CSSNode cSSNode4 = cSSNode2.jjtGetChild(i + 1);
                    this._readStyleDeclarationList(cSSNode4, arg_0 -> CSSNodeToDomainObject.lambda$_createPageRule$1((CSSPageMarginBlock)iCSSPageRuleMember, arg_0));
                    cSSPageRule.addMember(iCSSPageRuleMember);
                    ++i;
                    continue;
                }
                if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion)) continue;
                this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule body child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
            }
            return cSSPageRule;
        }
        String string = null;
        int n3 = 0;
        if (n > 0 && ECSSNodeType.PSEUDOPAGE.isNode((CSSNode)(serializable = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            string = ((CSSNode)serializable).getText();
            ++n3;
        }
        serializable = new CSSPageRule(string);
        ((CSSPageRule)serializable).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n3; i < n; ++i) {
            CSSNode cSSNode5 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode5, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode5, arg_0 -> CSSNodeToDomainObject.lambda$_createPageRule$2((CSSPageRule)serializable, arg_0));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode5, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule child: " + ECSSNodeType.getNodeName(cSSNode5, this.m_eVersion));
        }
        return serializable;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        cSSMediaRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    cSSMediaRule.addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cSSMediaRule.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSMediaRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode cSSNode) {
        Object object;
        Object object2;
        if (ECSSNodeType.MEDIUM.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            if (ECSSMedium.getFromNameOrNull(string) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + string + "'");
            }
            CSSMediaQuery cSSMediaQuery = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, string);
            cSSMediaQuery.setSourceLocation(cSSNode.getSourceLocation());
            return cSSMediaQuery;
        }
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAQUERY);
        int n = cSSNode.jjtGetNumChildren();
        int n2 = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (n > 0 && ECSSNodeType.MEDIAMODIFIER.isNode((CSSNode)(object2 = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            object = ((CSSNode)object2).getText();
            if (object != null) {
                if ("not".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported media modifier '" + (String)object + "' found!");
                }
            }
            ++n2;
        }
        object2 = null;
        if (n > n2 && ECSSNodeType.MEDIUM.isNode((CSSNode)(object = cSSNode.jjtGetChild(n2)), this.m_eVersion)) {
            object2 = ((CSSNode)object).getText();
            if (ECSSMedium.getFromNameOrNull((String)object2) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + (String)object2 + "'");
            }
            ++n2;
        }
        object = new CSSMediaQuery(eModifier, (String)object2);
        ((CSSMediaQuery)object).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(cSSNode2, this.m_eVersion)) {
                ((CSSMediaQuery)object).addMediaExpression(this._createMediaExpr(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media query child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode cSSNode) {
        CSSMediaExpression cSSMediaExpression;
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAEXPR);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 1 && n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1 or 2 children but got " + n + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        String string = cSSNode2.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(string) == null) {
            this.m_aErrorHandler.onCSSInterpretationWarning("Media expression uses unknown feature '" + string + "'");
        }
        if (n == 1) {
            cSSMediaExpression = new CSSMediaExpression(string);
        } else {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
            cSSMediaExpression = new CSSMediaExpression(string, this._createExpression(cSSNode3));
        }
        cSSMediaExpression.setSourceLocation(cSSNode.getSourceLocation());
        return cSSMediaExpression;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.FONTFACERULE);
        String string = cSSNode.getText();
        CSSFontFaceRule cSSFontFaceRule = new CSSFontFaceRule(string);
        cSSFontFaceRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSDeclaration -> cSSFontFaceRule.addDeclaration((CSSDeclaration)cSSDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSFontFaceRule;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.KEYFRAMESRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n == 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
        }
        String string = cSSNode.getText();
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String string2 = cSSNode2.getText();
        CSSKeyframesRule cSSKeyframesRule = new CSSKeyframesRule(string, string2);
        cSSKeyframesRule.setSourceLocation(cSSNode.getSourceLocation());
        CSSKeyframesBlock cSSKeyframesBlock = null;
        for (int i = 1; i < n; ++i) {
            CommonsArrayList<String> commonsArrayList;
            CSSNode cSSNode3 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(cSSNode3, this.m_eVersion)) {
                commonsArrayList = new CommonsArrayList<String>();
                for (CSSNode cSSNode4 : cSSNode3) {
                    this._expectNodeType(cSSNode4, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    commonsArrayList.add(cSSNode4.getText());
                }
                cSSKeyframesBlock = new CSSKeyframesBlock(commonsArrayList);
                cSSKeyframesBlock.setSourceLocation(cSSNode3.getSourceLocation());
                cSSKeyframesRule.addBlock(cSSKeyframesBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode3, this.m_eVersion)) {
                if (cSSKeyframesBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                commonsArrayList = cSSKeyframesBlock;
                this._readStyleDeclarationList(cSSNode3, cSSDeclaration -> commonsArrayList.addDeclaration((CSSDeclaration)cSSDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
        }
        return cSSKeyframesRule;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.VIEWPORTRULE);
        String string = cSSNode.getText();
        CSSViewportRule cSSViewportRule = new CSSViewportRule(string);
        cSSViewportRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                this._readStyleDeclarationList(cSSNode2, cSSDeclaration -> cSSViewportRule.addDeclaration((CSSDeclaration)cSSDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSViewportRule;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.NAMESPACERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child and at last 2 children but got " + n + "!");
        }
        String string = null;
        int n2 = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            ++n2;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
        this._expectNodeType(cSSNode2, ECSSNodeType.NAMESPACERULEURL);
        String string2 = CSSParseHelper.extractStringValue(cSSNode2.getText());
        CSSNamespaceRule cSSNamespaceRule = new CSSNamespaceRule(string, string2);
        cSSNamespaceRule.setSourceLocation(cSSNode.getSourceLocation());
        return cSSNamespaceRule;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected no children but got " + n + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(cSSNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(cSSNode, this.m_eVersion)) {
            ICSSSupportsConditionMember iCSSSupportsConditionMember;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if ((iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation cSSSupportsConditionNegation = new CSSSupportsConditionNegation(iCSSSupportsConditionMember);
            cSSSupportsConditionNegation.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSupportsConditionNegation;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(cSSNode, this.m_eVersion)) {
            CSSNode cSSNode2;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
                CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2);
                if (cSSDeclaration == null) {
                    throw new CSSHandlingException(cSSNode2, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = new CSSSupportsConditionDeclaration(cSSDeclaration);
                cSSSupportsConditionDeclaration.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSupportsConditionDeclaration;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                CSSSupportsConditionNested cSSSupportsConditionNested = new CSSSupportsConditionNested();
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsConditionNested.addMember(iCSSSupportsConditionMember);
                }
                return cSSSupportsConditionNested;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(cSSNode, this.m_eVersion)) {
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule cSSSupportsRule = new CSSSupportsRule();
        cSSSupportsRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsRule.addSupportConditionMember(iCSSSupportsConditionMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cSSSupportsRule.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSSupportsRule;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.UNKNOWNRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 2 children but got " + n + "!");
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
        this._expectNodeType(cSSNode3, ECSSNodeType.UNKNOWNRULEBODY);
        String string = cSSNode.getText();
        CSSUnknownRule cSSUnknownRule = new CSSUnknownRule(string);
        cSSUnknownRule.setSourceLocation(cSSNode.getSourceLocation());
        cSSUnknownRule.setParameterList(cSSNode2.getText());
        cSSUnknownRule.setBody(cSSNode3.getText());
        return cSSUnknownRule;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.ROOT);
        CascadingStyleSheet cascadingStyleSheet = new CascadingStyleSheet();
        cascadingStyleSheet.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.CHARSET.isNode(cSSNode2, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addImportRule(this._createImportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addNamespaceRule(this._createNamespaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cascadingStyleSheet.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cascadingStyleSheet;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode cSSNode) {
        CSSDeclarationList cSSDeclarationList = new CSSDeclarationList();
        cSSDeclarationList.setSourceLocation(cSSNode.getSourceLocation());
        this._readStyleDeclarationList(cSSNode, cSSDeclaration -> cSSDeclarationList.addDeclaration((CSSDeclaration)cSSDeclaration));
        return cSSDeclarationList;
    }

    private static /* synthetic */ void lambda$_createPageRule$2(CSSPageRule cSSPageRule, CSSDeclaration cSSDeclaration) {
        cSSPageRule.addMember(cSSDeclaration);
    }

    private static /* synthetic */ void lambda$_createPageRule$1(CSSPageMarginBlock cSSPageMarginBlock, CSSDeclaration cSSDeclaration) {
        cSSPageMarginBlock.addDeclaration(cSSDeclaration);
    }
}

