/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.parser;

import java.util.TreeSet;
import vuegwt.shaded.com.helger.css.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String INDENT = "    ";
    protected static final String EOL = "\n";
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        this(token, nArray, stringArray, null);
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray, String string) {
        super(ParseException._initialise(token, nArray, stringArray, string));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String _initialise(Token token, int[][] nArray, String[] stringArray, String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 < nArray[i].length) {
                n2 = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                treeSet.add(stringArray[nArray[i][j]]);
            }
        }
        for (String string2 : treeSet) {
            stringBuilder2.append(INDENT).append(string2).append(EOL);
        }
        stringBuilder.append("Encountered unexpected token:");
        Object object = token.next;
        for (n = 0; n < n2; ++n) {
            String string3 = ((Token)object).image;
            String string4 = ParseException.add_escapes(string3);
            if (n != 0) {
                stringBuilder.append(" ");
            }
            if (((Token)object).kind == 0) {
                stringBuilder.append(stringArray[0]);
                break;
            }
            stringBuilder.append(" \"");
            stringBuilder.append(string4);
            stringBuilder.append("\"");
            stringBuilder.append(" " + stringArray[((Token)object).kind]);
            object = ((Token)object).next;
        }
        stringBuilder.append(EOL).append(INDENT).append("at line " + token.next.beginLine + ", column " + token.next.beginColumn);
        stringBuilder.append(".").append(EOL);
        if (nArray.length != 0) {
            n = nArray.length;
            stringBuilder.append(EOL).append("Was expecting" + (n == 1 ? ":" : " one of:") + EOL + EOL);
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    static String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
            }
        }
        return stringBuilder.toString();
    }
}

