/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.property;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.ECSSVendorPrefix;
import vuegwt.shaded.com.helger.css.property.CSSPropertyEnum;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;
import vuegwt.shaded.com.helger.css.property.customizer.ICSSPropertyCustomizer;

@NotThreadSafe
public abstract class AbstractCSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0(n, "MinNumbers");
        ValueEnforcer.isGT0(n2, "MaxNumbers");
        ValueEnforcer.isTrue(n < n2, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0(n, "MinNumbers");
        ValueEnforcer.isGT0(n2, "MaxNumbers");
        ValueEnforcer.isTrue(n < n2, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractCSSPropertyEnums abstractCSSPropertyEnums = (AbstractCSSPropertyEnums)object;
        return this.m_nMinArgCount == abstractCSSPropertyEnums.m_nMinArgCount && this.m_nMaxArgCount == abstractCSSPropertyEnums.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("MinNumbers", this.m_nMinArgCount).append("MaxNumbers", this.m_nMaxArgCount).getToString();
    }
}

