/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.property;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.regex.RegExHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.ECSSVendorPrefix;
import vuegwt.shaded.com.helger.css.property.AbstractCSSProperty;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;
import vuegwt.shaded.com.helger.css.property.customizer.ICSSPropertyCustomizer;
import vuegwt.shaded.com.helger.css.utils.CSSNumberHelper;

@NotThreadSafe
public class CSSPropertyNumbers
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, bl, n, n2);
    }

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, bl, n, n2);
    }

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.isGT0(n, "MinNumbers");
        ValueEnforcer.isGT0(n2, "MaxNumbers");
        if (n2 < n) {
            throw new IllegalArgumentException("MaxNumbers (" + n2 + ") must be >= MinNumbers (" + n + ")");
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (super.isValidValue(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray(string.trim(), "\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (String string2 : stringArray) {
            if (CSSNumberHelper.isValueWithUnit(string2.trim(), this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyNumbers(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers);
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyNumbers(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyNumbers cSSPropertyNumbers = (CSSPropertyNumbers)object;
        return this.m_bWithPercentage == cSSPropertyNumbers.m_bWithPercentage && this.m_nMinNumbers == cSSPropertyNumbers.m_nMinNumbers && this.m_nMaxNumbers == cSSPropertyNumbers.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).getToString();
    }
}

