/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.propertyvalue;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;
import vuegwt.shaded.com.helger.css.property.ICSSProperty;
import vuegwt.shaded.com.helger.css.propertyvalue.CSSValue;
import vuegwt.shaded.com.helger.css.propertyvalue.ICSSMultiValue;

@Immutable
public class CSSValueList
implements ICSSMultiValue {
    private final ECSSProperty m_eProperty;
    private final ICommonsList<CSSValue> m_aValues;

    public CSSValueList(@Nonnull ECSSProperty eCSSProperty, @Nonnull ICSSProperty[] iCSSPropertyArray, @Nonnull String[] stringArray, boolean bl) {
        ValueEnforcer.notNull(eCSSProperty, "Property");
        ValueEnforcer.notEmptyNoNullValue(iCSSPropertyArray, "Properties");
        ValueEnforcer.notEmptyNoNullValue(stringArray, "Values");
        if (iCSSPropertyArray.length != stringArray.length) {
            throw new IllegalArgumentException("Different number of properties and values passed");
        }
        boolean bl2 = false;
        for (ICSSProperty iCSSProperty : iCSSPropertyArray) {
            if (iCSSProperty.getProp() != eCSSProperty) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new IllegalArgumentException("The property " + eCSSProperty + " is not contained in an ICSSProperty instance!");
        }
        this.m_eProperty = eCSSProperty;
        this.m_aValues = new CommonsArrayList<int>(iCSSPropertyArray.length);
        for (int i = 0; i < iCSSPropertyArray.length; ++i) {
            this.m_aValues.add(new CSSValue(iCSSPropertyArray[i], stringArray[i], bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSValue> getAllContainedValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_eProperty;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringHelper.getImplodedMapped(this.m_aValues, cSSValue -> cSSValue.getAsCSSString(iCSSWriterSettings, n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValueList cSSValueList = (CSSValueList)object;
        return this.m_aValues.equals(cSSValueList.m_aValues);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aValues)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("values", this.m_aValues).getToString();
    }
}

