/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.propertyvalue;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.annotation.ReturnsMutableCopy;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.hashcode.HashCodeGenerator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.ICSSWriterSettings;
import vuegwt.shaded.com.helger.css.property.ECSSProperty;
import vuegwt.shaded.com.helger.css.property.ICSSProperty;
import vuegwt.shaded.com.helger.css.propertyvalue.CSSValue;
import vuegwt.shaded.com.helger.css.propertyvalue.ICSSMultiValue;

@Immutable
public class CSSValueMultiValue
implements ICSSMultiValue {
    private final ICommonsList<CSSValue> m_aValues = new CommonsArrayList<CSSValue>();

    public CSSValueMultiValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull @Nonempty String[] stringArray, boolean bl) {
        ValueEnforcer.notNull(iCSSProperty, "Property");
        ValueEnforcer.notEmptyNoNullValue(stringArray, "Values");
        for (String string : stringArray) {
            this.m_aValues.add(new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSValue> getAllContainedValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aValues.getFirst().getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringHelper.getImplodedMapped(this.m_aValues, cSSValue -> cSSValue.getAsCSSString(iCSSWriterSettings, n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValueMultiValue cSSValueMultiValue = (CSSValueMultiValue)object;
        return this.m_aValues.equals(cSSValueMultiValue.m_aValues);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aValues)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("values", this.m_aValues).getToString();
    }
}

