/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.reader;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.charset.CharsetHelper;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.commons.io.IHasInputStream;
import vuegwt.shaded.com.helger.commons.io.IHasReader;
import vuegwt.shaded.com.helger.commons.io.resource.FileSystemResource;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingStringReader;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.commons.io.streamprovider.StringInputStreamProvider;
import vuegwt.shaded.com.helger.commons.io.streamprovider.StringReaderProvider;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.handler.CSSHandler;
import vuegwt.shaded.com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.handler.ICSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.handler.LoggingCSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.parser.CSSCharStream;
import vuegwt.shaded.com.helger.css.parser.CSSNode;
import vuegwt.shaded.com.helger.css.parser.CSSParseHelper;
import vuegwt.shaded.com.helger.css.parser.CharStream;
import vuegwt.shaded.com.helger.css.parser.ParseException;
import vuegwt.shaded.com.helger.css.parser.ParserCSS30;
import vuegwt.shaded.com.helger.css.parser.ParserCSS30TokenManager;
import vuegwt.shaded.com.helger.css.parser.ParserCSSCharsetDetector;
import vuegwt.shaded.com.helger.css.parser.ParserCSSCharsetDetectorTokenManager;
import vuegwt.shaded.com.helger.css.reader.CSSReaderSettings;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="s_aRWLock")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReader s_aInstance = new CSSReader();

    private CSSReader() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
            return s_aDefaultParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull(iCSSParseExceptionCallback, "DefaultParseExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
            return s_aDefaultParseExceptionHandler;
        });
    }

    @Nonnull
    public static ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "DefaultErrorHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = iCSSInterpretErrorHandler;
            return s_aDefaultInterpretErrorHandler;
        });
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback, boolean bl) {
        try {
            switch (eCSSVersion) {
                case CSS21: 
                case CSS30: {
                    ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                    parserCSS30TokenManager.setCustomErrorHandler(iCSSParseErrorHandler);
                    ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                    parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                    parserCSS30.setBrowserCompliantMode(bl);
                    return parserCSS30.styleSheet();
                }
            }
            throw new IllegalArgumentException("Unsupported CSS version " + eCSSVersion);
        }
        catch (ParseException parseException) {
            iCSSParseExceptionCallback.onException(parseException);
            return null;
        }
        catch (Throwable throwable) {
            iCSSParseExceptionCallback.onException(new ParseException(throwable.getMessage()));
            return null;
        }
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS(new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        ValueEnforcer.notNull(charset, "FallbackCharset");
        ValueEnforcer.notNull(eCSSVersion, "Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReader.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(charset, "FallbackCharset");
        return CSSReader.isValidCSS(StreamHelper.createReader(inputStream, charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(string, "CSS");
        return CSSReader.isValidCSS(new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(eCSSVersion, "Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, CSSReader.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback(), false);
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringStream(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream(new StringInputStreamProvider(string, cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringReader(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromReader(new StringReaderProvider(string), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream(new FileSystemResource(file), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM(inputStream);
        Charset charset = inputStreamAndCharset.getCharset();
        Charset charset2 = charset;
        if (charset2 == null) {
            charset2 = StandardCharsets.ISO_8859_1;
        }
        InputStreamReader inputStreamReader = StreamHelper.createReader(inputStreamAndCharset.getInputStream(), charset2);
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ParserCSSCharsetDetectorTokenManager parserCSSCharsetDetectorTokenManager = new ParserCSSCharsetDetectorTokenManager(cSSCharStream);
            ParserCSSCharsetDetector parserCSSCharsetDetector = new ParserCSSCharsetDetector(parserCSSCharsetDetectorTokenManager);
            String string = parserCSSCharsetDetector.styleSheetCharset().getText();
            if (string == null) {
                Charset charset3 = charset;
                return charset3;
            }
            String string2 = CSSParseHelper.extractStringValue(string);
            Charset charset4 = CharsetHelper.getCharsetFromName(string2);
            if (charset != null && !charset.equals(charset4)) {
                s_aLogger.warn("The charset found in the CSS data (" + charset4.name() + ") differs from the charset determined by the BOM (" + charset.name() + ") -> Using the read charset");
            }
            Charset charset5 = charset4;
            return charset5;
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Failed to parse CSS charset definition", parseException);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to parse CSS charset definition", throwable);
        }
        finally {
            StreamHelper.close(inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull CSSReaderSettings cSSReaderSettings) {
        Charset charset;
        Charset charset2;
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        ValueEnforcer.notNull(cSSReaderSettings, "Settings");
        try {
            charset2 = CSSReader.getCharsetDeclaredInCSS(iHasInputStream);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (charset2 != null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Reading CSS definition again with explicit charset '" + charset2.name() + "'");
            }
            charset = charset2;
        } else {
            charset = cSSReaderSettings.getFallbackCharset();
        }
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM(inputStream);
        InputStream inputStream2 = inputStreamAndCharset.getInputStream();
        InputStreamReader inputStreamReader = StreamHelper.createReader(inputStream2, charset);
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            boolean bl;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            cSSCharStream.setTabSize(cSSReaderSettings.getTabSize());
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl = cSSReaderSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode, iCSSInterpretErrorHandler);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close(inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader iHasReader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromReader(iHasReader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader iHasReader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull(iHasReader, "ReaderProvider");
        ValueEnforcer.notNull(cSSReaderSettings, "Settings");
        Reader reader = iHasReader.getReader();
        if (reader == null) {
            return null;
        }
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            boolean bl;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            cSSCharStream.setTabSize(cSSReaderSettings.getTabSize());
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl = cSSReaderSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode, iCSSInterpretErrorHandler);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close(reader);
        }
    }
}

