/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.reader;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.concurrent.SimpleReadWriteLock;
import vuegwt.shaded.com.helger.commons.io.IHasInputStream;
import vuegwt.shaded.com.helger.commons.io.resource.FileSystemResource;
import vuegwt.shaded.com.helger.commons.io.resource.IReadableResource;
import vuegwt.shaded.com.helger.commons.io.stream.NonBlockingStringReader;
import vuegwt.shaded.com.helger.commons.io.stream.StreamHelper;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CSSDeclarationList;
import vuegwt.shaded.com.helger.css.handler.CSSHandler;
import vuegwt.shaded.com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.handler.ICSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.handler.LoggingCSSParseExceptionCallback;
import vuegwt.shaded.com.helger.css.parser.CSSCharStream;
import vuegwt.shaded.com.helger.css.parser.CSSNode;
import vuegwt.shaded.com.helger.css.parser.CharStream;
import vuegwt.shaded.com.helger.css.parser.ParseException;
import vuegwt.shaded.com.helger.css.parser.ParserCSS30;
import vuegwt.shaded.com.helger.css.parser.ParserCSS30TokenManager;
import vuegwt.shaded.com.helger.css.reader.CSSReaderSettings;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import vuegwt.shaded.com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="s_aRWLock")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReaderDeclarationList s_aInstance = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
            return s_aDefaultParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull(iCSSParseExceptionCallback, "DefaultParseExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
            return s_aDefaultParseExceptionHandler;
        });
    }

    @Nonnull
    public static ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return s_aRWLock.readLocked(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull(iCSSInterpretErrorHandler, "DefaultErrorHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = iCSSInterpretErrorHandler;
            return s_aDefaultInterpretErrorHandler;
        });
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        switch (eCSSVersion) {
            case CSS21: 
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                parserCSS30TokenManager.setCustomErrorHandler(iCSSParseErrorHandler);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS30.styleDeclarationList();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionCallback.onException(parseException);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS(new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        ValueEnforcer.notNull(charset, "Charset");
        ValueEnforcer.notNull(eCSSVersion, "Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(charset, "Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamHelper.createReader(inputStream, charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(string, "CSS");
        return CSSReaderDeclarationList.isValidCSS(new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(eCSSVersion, "Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, CSSReaderDeclarationList.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, iCSSParseErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, null, iCSSParseExceptionCallback);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader(inputStream, charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader(inputStream, charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader(inputStream, charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader(inputStream, charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader(inputStream, charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cSSReaderSettings, "Settings");
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReaderDeclarationList.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReaderDeclarationList.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback)) == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReaderDeclarationList.getDefaultInterpretErrorHandler();
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eCSSVersion, cSSNode, iCSSInterpretErrorHandler);
            return cSSDeclarationList;
        }
        finally {
            StreamHelper.close(reader);
        }
    }
}

