/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.reader.errorhandler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.string.ToStringGenerator;
import vuegwt.shaded.com.helger.css.parser.ParseException;
import vuegwt.shaded.com.helger.css.parser.ReadOnlyToken;
import vuegwt.shaded.com.helger.css.parser.Token;
import vuegwt.shaded.com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;

@Immutable
public class CSSParseError {
    private final ReadOnlyToken m_aLastValidToken;
    private final String m_sExpectedTokens;
    private final ReadOnlyToken m_aFirstSkippedToken;
    private final ReadOnlyToken m_aLastSkippedToken;
    private final String m_sErrorMessage;

    public CSSParseError(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ErrorMsg");
        this.m_aLastValidToken = null;
        this.m_sExpectedTokens = null;
        this.m_aFirstSkippedToken = null;
        this.m_aLastSkippedToken = null;
        this.m_sErrorMessage = string;
    }

    public CSSParseError(@Nonnull Token token, @Nonnull int[][] nArray, @Nonnull String[] stringArray, @Nullable Token token2) {
        ValueEnforcer.notNull(token, "LastValidToken");
        ValueEnforcer.notNull(nArray, "ExpectedTokenSequencesVal");
        ValueEnforcer.notNull(stringArray, "TokenImageVal");
        this.m_aLastValidToken = new ReadOnlyToken(token);
        StringBuilder stringBuilder = new StringBuilder();
        for (int[] nArray2 : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            for (int n : nArray2) {
                stringBuilder.append(' ').append(stringArray[n]);
            }
        }
        this.m_sExpectedTokens = stringBuilder.toString();
        this.m_aFirstSkippedToken = new ReadOnlyToken(token.next);
        this.m_aLastSkippedToken = token2 == null ? null : new ReadOnlyToken(token2);
        this.m_sErrorMessage = LoggingCSSParseErrorHandler.createLoggingStringParseError(token, nArray, stringArray, token2);
    }

    @Nullable
    public ReadOnlyToken getLastValidToken() {
        return this.m_aLastValidToken;
    }

    @Nullable
    public String getExpectedTokens() {
        return this.m_sExpectedTokens;
    }

    @Nullable
    public ReadOnlyToken getFirstSkippedToken() {
        return this.m_aFirstSkippedToken;
    }

    @Nullable
    public ReadOnlyToken getLastSkippedToken() {
        return this.m_aLastSkippedToken;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("lastValidToken", this.m_aLastValidToken).appendIfNotNull("expectedTokens", this.m_sExpectedTokens).appendIfNotNull("firstSkippedToken", this.m_aFirstSkippedToken).appendIfNotNull("lastSkippedToken", this.m_aLastSkippedToken).append("errorMessage", this.m_sErrorMessage).getToString();
    }

    @Nonnull
    public static CSSParseError createUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(token, string, string2));
    }

    @Nonnull
    public static CSSParseError createBrowserCompliantSkip(@Nullable ParseException parseException, @Nonnull Token token, @Nonnull Token token2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(parseException, token, token2));
    }

    @Nonnull
    public static CSSParseError createIllegalCharacter(char c) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(c));
    }
}

