/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.tools;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.annotation.Nonempty;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsArrayList;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsList;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CSSImportRule;
import vuegwt.shaded.com.helger.css.decl.CSSMediaQuery;
import vuegwt.shaded.com.helger.css.decl.CSSMediaRule;
import vuegwt.shaded.com.helger.css.decl.CSSNamespaceRule;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.decl.ICSSTopLevelRule;
import vuegwt.shaded.com.helger.css.reader.CSSReader;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools s_aInstance = new MediaQueryTools();

    private MediaQueryTools() {
    }

    @Nullable
    public static ICommonsList<CSSMediaQuery> parseToMediaQuery(@Nullable String string, @Nonnull ECSSVersion eCSSVersion) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = "@media " + string + " {}";
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string2, eCSSVersion);
        if (cascadingStyleSheet == null) {
            return null;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)cascadingStyleSheet.getAllMediaRules().get(0);
        return cSSMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet cascadingStyleSheet, boolean bl) {
        if (cascadingStyleSheet == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        return !cascadingStyleSheet.hasMediaRules();
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSMediaQuery cSSMediaQuery, boolean bl) {
        return MediaQueryTools.getWrappedInMediaQuery(cascadingStyleSheet, new CommonsArrayList<CSSMediaQuery>(cSSMediaQuery), bl);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @Nonempty Iterable<? extends CSSMediaQuery> iterable, boolean bl) {
        ValueEnforcer.notNull(cascadingStyleSheet, "CSS");
        ValueEnforcer.notEmpty(iterable, "MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(cascadingStyleSheet, bl)) {
            return null;
        }
        CascadingStyleSheet cascadingStyleSheet2 = new CascadingStyleSheet();
        for (CSSImportRule object : cascadingStyleSheet.getAllImportRules()) {
            if (object.hasMediaQueries()) {
                cascadingStyleSheet2.addImportRule(object);
                continue;
            }
            CSSImportRule cSSImportRule = new CSSImportRule(object.getLocation());
            for (CSSMediaQuery cSSMediaQuery : iterable) {
                cSSImportRule.addMediaQuery(cSSMediaQuery);
            }
            cascadingStyleSheet2.addImportRule(cSSImportRule);
        }
        for (CSSNamespaceRule cSSNamespaceRule : cascadingStyleSheet.getAllNamespaceRules()) {
            cascadingStyleSheet2.addNamespaceRule(cSSNamespaceRule);
        }
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        for (CSSMediaQuery cSSMediaQuery : iterable) {
            cSSMediaRule.addMediaQuery(cSSMediaQuery);
        }
        for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
            cSSMediaRule.addRule(iCSSTopLevelRule);
        }
        cascadingStyleSheet2.addRule(cSSMediaRule);
        return cascadingStyleSheet2;
    }
}

