/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.utils;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.commons.collection.impl.CommonsHashMap;
import vuegwt.shaded.com.helger.commons.collection.impl.ICommonsMap;
import vuegwt.shaded.com.helger.commons.compare.IComparator;
import vuegwt.shaded.com.helger.commons.string.StringHelper;
import vuegwt.shaded.com.helger.commons.string.StringParser;
import vuegwt.shaded.com.helger.css.ECSSUnit;
import vuegwt.shaded.com.helger.css.propertyvalue.CSSSimpleValueWithUnit;

@Immutable
public final class CSSNumberHelper {
    private static final ICommonsMap<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper s_aInstance;

    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CSSValue");
        return s_aNameToUnitMap.findFirstValue(entry -> string.endsWith((String)entry.getKey()));
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String string) {
        ECSSUnit eCSSUnit = CSSNumberHelper.getMatchingUnitInclPercentage(string);
        return eCSSUnit == null || eCSSUnit == ECSSUnit.PERCENTAGE ? null : eCSSUnit;
    }

    public static boolean isNumberValue(@Nullable String string) {
        String string2 = StringHelper.trim(string);
        return StringHelper.hasText(string2) && StringParser.isDouble(string2);
    }

    public static boolean isValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.isValueWithUnit(string, true);
    }

    public static boolean isValueWithUnit(@Nullable String string, boolean bl) {
        return CSSNumberHelper.getValueWithUnit(string, bl) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string, boolean bl) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasText(string2)) {
            BigDecimal bigDecimal;
            ECSSUnit eCSSUnit;
            if (string2.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit2 = eCSSUnit = bl ? CSSNumberHelper.getMatchingUnitInclPercentage(string2) : CSSNumberHelper.getMatchingUnitExclPercentage(string2);
            if (eCSSUnit != null && (bigDecimal = StringParser.parseBigDecimal(string2 = string2.substring(0, string2.length() - eCSSUnit.getName().length()).trim())) != null) {
                return new CSSSimpleValueWithUnit(bigDecimal, eCSSUnit);
            }
        }
        return null;
    }

    static {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            commonsHashMap.put(eCSSUnit.getName(), eCSSUnit);
        }
        s_aNameToUnitMap = commonsHashMap.getSortedByKey(IComparator.getComparatorStringLongestFirst());
        s_aInstance = new CSSNumberHelper();
    }
}

