/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.com.helger.css.writer;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import vuegwt.shaded.com.helger.commons.ValueEnforcer;
import vuegwt.shaded.com.helger.css.ECSSVersion;
import vuegwt.shaded.com.helger.css.decl.CascadingStyleSheet;
import vuegwt.shaded.com.helger.css.reader.CSSReader;
import vuegwt.shaded.com.helger.css.writer.CSSWriter;
import vuegwt.shaded.com.helger.css.writer.CSSWriterSettings;
import vuegwt.shaded.org.slf4j.Logger;
import vuegwt.shaded.org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor s_aInstance = new CSSCompressor();

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(string, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, boolean bl) {
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(eCSSVersion, true);
        cSSWriterSettings.setRemoveUnnecessaryCode(bl);
        return CSSCompressor.getRewrittenCSS(string, cSSWriterSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String string, @Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull(string, "OriginalCSS");
        ValueEnforcer.notNull(cSSWriterSettings, "Settings");
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string, cSSWriterSettings.getVersion());
        if (cascadingStyleSheet != null) {
            try {
                return new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet);
            }
            catch (Exception exception) {
                s_aLogger.warn("Failed to write optimized CSS!", exception);
            }
        }
        return string;
    }
}

