/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.net.htmlparser.jericho;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import vuegwt.shaded.net.htmlparser.jericho.Config;
import vuegwt.shaded.net.htmlparser.jericho.FormControl;
import vuegwt.shaded.net.htmlparser.jericho.FormField;
import vuegwt.shaded.net.htmlparser.jericho.OutputDocument;

public final class FormFields
extends AbstractCollection<FormField> {
    private final LinkedHashMap<String, FormField> map = new LinkedHashMap();
    private final ArrayList<FormControl> formControls = new ArrayList();
    private Column[] columns = null;

    public FormFields(Collection<FormControl> collection) {
        for (FormControl formControl : collection) {
            if (formControl.getName() == null || formControl.getName().length() == 0) continue;
            formControl.addToFormFields(this);
            this.formControls.add(formControl);
        }
    }

    public int getCount() {
        return this.map.size();
    }

    @Override
    public int size() {
        return this.getCount();
    }

    public FormField get(String string) {
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            string = string.toLowerCase();
        }
        return this.map.get(string);
    }

    @Override
    public Iterator<FormField> iterator() {
        return this.map.values().iterator();
    }

    public List<String> getValues(String string) {
        FormField formField = this.get(string);
        return formField == null ? null : formField.getValues();
    }

    public Map<String, String[]> getDataSet() {
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>((int)((double)this.getCount() / 0.7));
        for (FormField formField : this) {
            List<String> list = formField.getValues();
            if (list.isEmpty()) continue;
            linkedHashMap.put(formField.getName(), list.toArray(new String[list.size()]));
        }
        return linkedHashMap;
    }

    public void clearValues() {
        for (FormControl formControl : this.formControls) {
            formControl.clearValues();
        }
    }

    public void setDataSet(Map<String, String[]> map) {
        this.clearValues();
        if (this.map == null) {
            return;
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String string = entry.getKey();
            FormField formField = this.get(string);
            if (formField == null) continue;
            formField.addValues(entry.getValue());
        }
    }

    public boolean setValue(String string, String string2) {
        FormField formField = this.get(string);
        return formField == null ? false : formField.setValue(string2);
    }

    public boolean addValue(String string, String string2) {
        FormField formField = this.get(string);
        return formField == null ? false : formField.addValue(string2);
    }

    public String[] getColumnLabels() {
        this.initColumns();
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            String string = column.formField.getFirstFormControl().getName();
            stringArray[i] = column.predefinedValue != null ? string + '.' + column.predefinedValue : string;
        }
        return stringArray;
    }

    public String[] getColumnValues(Map<String, String[]> map) {
        this.initColumns();
        String[] stringArray = new String[this.columns.length];
        if (Config.ColumnValueFalse != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].isBoolean) continue;
                stringArray[i] = Config.ColumnValueFalse;
            }
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String string = entry.getKey();
            FormField formField = this.get(string);
            if (formField == null) continue;
            int n = formField.columnIndex;
            block2: for (String string2 : entry.getValue()) {
                for (int i = n; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    if (column.formField != formField) continue block2;
                    if (column.predefinedValue != null) {
                        if (!column.predefinedValue.equals(string2)) continue;
                        stringArray[i] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (column.isBoolean) {
                        if (string2 == null) continue block2;
                        stringArray[i] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (stringArray[i] == null) {
                        stringArray[i] = string2;
                        continue block2;
                    }
                    stringArray[i] = stringArray[i] + Config.ColumnMultipleValueSeparator + string2;
                    continue block2;
                }
            }
        }
        return stringArray;
    }

    public String[] getColumnValues() {
        return this.getColumnValues(this.getDataSet());
    }

    private void initColumns() {
        if (this.columns != null) {
            return;
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (FormField formField : this) {
            formField.columnIndex = arrayList.size();
            if (!formField.allowsMultipleValues() || formField.getPredefinedValues().isEmpty()) {
                arrayList.add(new Column(formField, formField.getPredefinedValues().size() == 1, null));
                continue;
            }
            for (String string : formField.getPredefinedValues()) {
                arrayList.add(new Column(formField, true, string));
            }
            if (formField.getUserValueCount() <= 0) continue;
            arrayList.add(new Column(formField, false, null));
        }
        this.columns = arrayList.toArray(new Column[arrayList.size()]);
    }

    public List<FormControl> getFormControls() {
        return this.formControls;
    }

    public void merge(FormFields formFields) {
        for (FormField formField : formFields) {
            String string = formField.getName();
            FormField formField2 = this.get(string);
            if (formField2 == null) {
                this.map.put(formField.getName(), formField);
                continue;
            }
            formField2.merge(formField);
        }
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FormField formField : this) {
            stringBuilder.append(formField);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getDebugInfo();
    }

    void add(FormControl formControl) {
        this.add(formControl, formControl.getPredefinedValue());
    }

    void add(FormControl formControl, String string) {
        this.add(formControl, string, formControl.name);
    }

    void addName(FormControl formControl, String string) {
        this.add(formControl, null, string);
    }

    void add(FormControl formControl, String string, String string2) {
        FormField formField;
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            string2 = string2.toLowerCase();
        }
        if ((formField = this.map.get(string2)) == null) {
            formField = new FormField(string2);
            this.map.put(formField.getName(), formField);
        }
        formField.addFormControl(formControl, string);
    }

    void replaceInOutputDocument(OutputDocument outputDocument) {
        for (FormControl formControl : this.formControls) {
            outputDocument.replace(formControl);
        }
    }

    private static class Column {
        public FormField formField;
        public boolean isBoolean;
        public String predefinedValue;

        public Column(FormField formField, boolean bl, String string) {
            this.formField = formField;
            this.isBoolean = bl;
            this.predefinedValue = string;
        }
    }
}

