/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.net.htmlparser.jericho;

import java.util.HashMap;
import java.util.Map;
import vuegwt.shaded.net.htmlparser.jericho.Element;
import vuegwt.shaded.net.htmlparser.jericho.Segment;

final class RendererCSS {
    private static Map<String, Float> UNIT_FACTOR = new HashMap<String, Float>();

    RendererCSS() {
    }

    public static int getTopMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.top, n);
    }

    public static int getBottomMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.bottom, n);
    }

    public static int getLeftMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.left, n);
    }

    public static int getRightMargin(Element element, int n) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.right, n);
    }

    private static String get(Element element) {
        return element.getAttributeValue("style");
    }

    private static int getMargin(String string, Side side, int n) {
        int n2;
        if (string == null) {
            return n;
        }
        String[] stringArray = string.split(";");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = stringArray[n2].toLowerCase().trim();
        }
        n2 = RendererCSS.getStyleValue(stringArray, side, "margin");
        int n3 = RendererCSS.getStyleValue(stringArray, side, "padding");
        if (n2 == -1) {
            return n3 != -1 ? n3 : n;
        }
        return n3 != -1 ? n2 + n3 : n2;
    }

    private static int getStyleValue(String[] stringArray, Side side, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n2;
            String string3 = stringArray[i];
            if (string3.length() <= string.length() + 1 || !string3.startsWith(string) || (n2 = string3.indexOf(58)) == -1 || (string2 = string3.substring(n2 + 1).trim()).length() == 0) continue;
            boolean bl = false;
            int n3 = string.length();
            if (string3.charAt(string.length()) == '-' && string3.startsWith(side.name(), string.length() + 1)) {
                bl = true;
                n3 = string.length() + 1 + side.name().length();
                if (string3.length() <= n3 + 1) continue;
            }
            if (n3 != n2 && !Segment.isWhiteSpace(string3.charAt(n3))) continue;
            if (!bl) {
                String[] stringArray2 = string2.split("\\s+");
                int n4 = side.ordinal();
                int n5 = stringArray2.length;
                if (n5 == 0) continue;
                if (n5 == 1) {
                    n4 = 0;
                } else if (n5 == 2) {
                    n4 = side.ordinal() % 2;
                } else if (n5 == 3 && side == Side.left) {
                    n4 = 1;
                }
                string2 = stringArray2[n4].trim();
            }
            int n6 = 0;
            if (string2.length() == 0 || string2.charAt(string2.length() - 1) == '%' || string2.equals("auto") || string2.equals("inherit")) continue;
            if (string2.length() < 3) {
                if (!string2.equals("0")) {
                    continue;
                }
            } else {
                float f;
                Float f2 = UNIT_FACTOR.get(string2.substring(string2.length() - 2));
                if (f2 == null) continue;
                try {
                    f = Float.parseFloat(string2.substring(0, string2.length() - 2));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                n6 = Math.round(f * f2.floatValue());
            }
            if (bl) {
                return n6;
            }
            n = n6;
        }
        return n;
    }

    static {
        UNIT_FACTOR.put("em", Float.valueOf(1.0f));
        UNIT_FACTOR.put("ex", Float.valueOf(1.0f));
        UNIT_FACTOR.put("px", Float.valueOf(0.125f));
        UNIT_FACTOR.put("in", Float.valueOf(8.0f));
        UNIT_FACTOR.put("cm", Float.valueOf(3.0f));
        UNIT_FACTOR.put("mm", Float.valueOf(0.3f));
        UNIT_FACTOR.put("pt", Float.valueOf(0.1f));
        UNIT_FACTOR.put("pc", Float.valueOf(1.2f));
    }

    private static enum Side {
        top,
        right,
        bottom,
        left;

    }
}

