/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import vuegwt.shaded.net.htmlparser.jericho.CharStreamSource;
import vuegwt.shaded.net.htmlparser.jericho.CharStreamSourceUtil;
import vuegwt.shaded.net.htmlparser.jericho.Element;
import vuegwt.shaded.net.htmlparser.jericho.EndTag;
import vuegwt.shaded.net.htmlparser.jericho.HTMLElements;
import vuegwt.shaded.net.htmlparser.jericho.Segment;
import vuegwt.shaded.net.htmlparser.jericho.Source;
import vuegwt.shaded.net.htmlparser.jericho.StartTag;
import vuegwt.shaded.net.htmlparser.jericho.StartTagType;
import vuegwt.shaded.net.htmlparser.jericho.Tag;

public final class SourceFormatter
implements CharStreamSource {
    private final Segment segment;
    private String indentString = "\t";
    private boolean tidyTags = false;
    private boolean collapseWhiteSpace = false;
    private boolean removeLineBreaks = false;
    private boolean indentAllElements = false;
    private String newLine = null;

    public SourceFormatter(Segment segment) {
        this.segment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        new Processor(this.segment, this.getIndentString(), this.getTidyTags(), this.getCollapseWhiteSpace(), this.getRemoveLineBreaks(), this.getIndentAllElements(), this.getIndentAllElements(), this.getNewLine()).appendTo(appendable);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.segment.length() * 2;
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public SourceFormatter setIndentString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("indentString property must not be null");
        }
        this.indentString = string;
        return this;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public SourceFormatter setTidyTags(boolean bl) {
        this.tidyTags = bl;
        return this;
    }

    public boolean getTidyTags() {
        return this.tidyTags;
    }

    public SourceFormatter setCollapseWhiteSpace(boolean bl) {
        this.collapseWhiteSpace = bl;
        return this;
    }

    public boolean getCollapseWhiteSpace() {
        return this.collapseWhiteSpace;
    }

    SourceFormatter setRemoveLineBreaks(boolean bl) {
        this.removeLineBreaks = bl;
        return this;
    }

    boolean getRemoveLineBreaks() {
        return this.removeLineBreaks;
    }

    public SourceFormatter setIndentAllElements(boolean bl) {
        this.indentAllElements = bl;
        return this;
    }

    public boolean getIndentAllElements() {
        return this.indentAllElements;
    }

    public SourceFormatter setNewLine(String string) {
        this.newLine = string;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.segment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    private static final class Processor {
        private final Segment segment;
        private final CharSequence sourceText;
        private final String indentString;
        private final boolean tidyTags;
        private final boolean collapseWhiteSpace;
        private final boolean removeLineBreaks;
        private final boolean indentAllElements;
        private final boolean indentScriptElements;
        private final String newLine;
        private Appendable appendable;
        private Tag nextTag;
        private int index;

        public Processor(Segment segment, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2) {
            this.segment = segment;
            this.sourceText = segment.source.toString();
            this.indentString = string;
            this.tidyTags = bl;
            this.collapseWhiteSpace = bl2 || bl3;
            this.removeLineBreaks = bl3;
            this.indentAllElements = bl4;
            this.indentScriptElements = bl5;
            this.newLine = string2;
        }

        public void appendTo(Appendable appendable) throws IOException {
            this.appendable = appendable;
            if (this.segment instanceof Source) {
                ((Source)this.segment).fullSequentialParse();
            }
            this.nextTag = this.segment.source.getNextTag(this.segment.begin);
            this.index = this.segment.begin;
            this.appendContent(this.segment.end, this.segment.getChildElements(), 0);
        }

        private void appendContent(int n, List<Element> list, int n2) throws IOException {
            assert (this.index <= n);
            for (Element element : list) {
                int n3 = element.begin;
                if (n3 >= n) break;
                if (this.indentAllElements) {
                    this.appendText(n3, n2);
                    this.appendElement(element, n2, n, false, false);
                    continue;
                }
                if (this.inlinable(element)) continue;
                this.appendText(n3, n2);
                String string = element.getName();
                if (string == "pre" || string == "textarea") {
                    this.appendElement(element, n2, n, true, true);
                    continue;
                }
                if (string == "script") {
                    this.appendElement(element, n2, n, true, false);
                    continue;
                }
                this.appendElement(element, n2, n, false, !this.removeLineBreaks && this.containsOnlyInlineLevelChildElements(element));
            }
            this.appendText(n, n2);
            assert (this.index == n);
        }

        private boolean inlinable(Element element) {
            StartTagType startTagType = element.getStartTag().getStartTagType();
            if (startTagType != StartTagType.NORMAL) {
                return true;
            }
            String string = element.getName();
            if (string == "script") {
                return !this.indentScriptElements;
            }
            if (this.removeLineBreaks && !HTMLElements.getElementNames().contains(string)) {
                return true;
            }
            if (!HTMLElements.getInlineLevelElementNames().contains(string)) {
                return false;
            }
            if (string == "textarea") {
                return false;
            }
            if (this.removeLineBreaks) {
                return true;
            }
            return this.containsOnlyInlineLevelChildElements(element);
        }

        private void appendText(int n, int n2) throws IOException {
            assert (this.index <= n);
            if (this.index == n) {
                return;
            }
            while (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                if (++this.index != n) continue;
                return;
            }
            this.appendIndent(n2);
            if (this.collapseWhiteSpace) {
                this.appendTextCollapseWhiteSpace(n, n2);
            } else {
                this.appendTextInline(n, n2, false);
            }
            this.appendFormattingNewLine();
            assert (this.index == n);
        }

        private void appendElement(Element element, int n, int n2, boolean bl, boolean bl2) throws IOException {
            int n3;
            assert (this.index == element.begin);
            assert (this.index < n2);
            StartTag startTag = element.getStartTag();
            EndTag endTag = element.getEndTag();
            this.appendIndent(n);
            this.appendTag(startTag, n, n2);
            if (this.index == n2) {
                this.appendFormattingNewLine();
                assert (this.index == Math.min(element.end, n2)) : this.index;
                return;
            }
            if (!bl2) {
                this.appendFormattingNewLine();
            }
            if (n2 < (n3 = element.getContentEnd())) {
                n3 = n2;
            }
            if (this.index < n3) {
                if (bl) {
                    if (bl2) {
                        this.appendContentPreformatted(n3, n);
                    } else {
                        this.appendIndentedScriptContent(n3, n + 1);
                    }
                } else if (bl2) {
                    if (this.collapseWhiteSpace) {
                        this.appendTextCollapseWhiteSpace(n3, n);
                    } else if (!this.appendTextInline(n3, n, true)) {
                        this.appendFormattingNewLine();
                        bl2 = false;
                    }
                } else {
                    this.appendContent(n3, element.getChildElements(), n + 1);
                }
            }
            if (endTag != null && n2 > endTag.begin) {
                if (!bl2) {
                    this.appendIndent(n);
                }
                assert (this.index == endTag.begin);
                this.appendTag(endTag, n, n2);
                this.appendFormattingNewLine();
            } else if (bl2) {
                this.appendFormattingNewLine();
            }
            assert (this.index == Math.min(element.end, n2)) : this.index;
        }

        private void updateNextTag() {
            while (this.nextTag != null) {
                if (this.nextTag.begin >= this.index) {
                    return;
                }
                this.nextTag = this.nextTag.getNextTag();
            }
        }

        private void appendIndentedScriptContent(int n, int n2) throws IOException {
            assert (this.index < n);
            if (this.removeLineBreaks) {
                this.appendTextRemoveIndentation(n);
                assert (this.index == n);
                return;
            }
            int n3 = this.getStartOfLinePos(n, false);
            if (this.index == n) {
                return;
            }
            if (n3 == -1) {
                this.appendIndent(n2);
                this.appendLineKeepWhiteSpace(n, n2);
                this.appendEssentialNewLine();
                if (this.index == n) {
                    return;
                }
                n3 = this.getStartOfLinePos(n, true);
                if (this.index == n) {
                    return;
                }
            }
            this.appendTextPreserveIndentation(n, n2, this.index - n3);
            this.appendEssentialNewLine();
            assert (this.index == n);
        }

        private boolean appendTextPreserveIndentation(int n, int n2) throws IOException {
            assert (this.index < n);
            if (this.removeLineBreaks) {
                return this.appendTextRemoveIndentation(n);
            }
            this.appendLineKeepWhiteSpace(n, n2);
            if (this.index == n) {
                return true;
            }
            int n3 = this.getStartOfLinePos(n, true);
            if (this.index == n) {
                return true;
            }
            this.appendEssentialNewLine();
            this.appendTextPreserveIndentation(n, n2 + 1, this.index - n3);
            assert (this.index == n);
            return false;
        }

        private void appendTextPreserveIndentation(int n, int n2, int n3) throws IOException {
            assert (this.index < n);
            this.appendIndent(n2);
            this.appendLineKeepWhiteSpace(n, n2);
            while (this.index != n) {
                char c;
                for (int i = 0; i < n3 && ((c = this.sourceText.charAt(this.index)) == ' ' || c == '\t'); ++i) {
                    if (++this.index != n) continue;
                    return;
                }
                this.appendEssentialNewLine();
                this.appendIndent(n2);
                this.appendLineKeepWhiteSpace(n, n2);
            }
            assert (this.index == n);
        }

        private boolean appendTextRemoveIndentation(int n) throws IOException {
            assert (this.index < n);
            this.appendLineKeepWhiteSpace(n, 0);
            if (this.index == n) {
                return true;
            }
            while (this.index != n) {
                char c;
                while ((c = this.sourceText.charAt(this.index)) == ' ' || c == '\t') {
                    if (++this.index != n) continue;
                    return false;
                }
                this.appendEssentialNewLine();
                this.appendLineKeepWhiteSpace(n, 0);
            }
            assert (this.index == n);
            return false;
        }

        private int getStartOfLinePos(int n, boolean bl) {
            int n2;
            int n3 = n2 = bl ? this.index : -1;
            do {
                char c;
                if ((c = this.sourceText.charAt(this.index)) == '\n' || c == '\r') {
                    n2 = this.index + 1;
                    continue;
                }
                if (c != ' ' && c != '\t') break;
            } while (++this.index != n);
            return n2;
        }

        private void appendSpecifiedTextInline(CharSequence charSequence, int n) throws IOException {
            int n2 = charSequence.length();
            int n3 = this.appendSpecifiedLine(charSequence, 0);
            if (n3 < n2) {
                int n4 = n + 1;
                while (true) {
                    if (Segment.isWhiteSpace(charSequence.charAt(n3))) {
                        if (++n3 < n2) continue;
                        return;
                    }
                    this.appendEssentialNewLine();
                    this.appendIndent(n4);
                    if ((n3 = this.appendSpecifiedLine(charSequence, n3)) >= n2) break;
                }
            }
        }

        private int appendSpecifiedLine(CharSequence charSequence, int n) throws IOException {
            int n2 = charSequence.length();
            do {
                int n3;
                char c;
                if ((c = charSequence.charAt(n)) == '\r' && (n3 = n + 1) < n2 && charSequence.charAt(n3) == '\n') {
                    return n + 2;
                }
                if (c == '\n') {
                    return n + 1;
                }
                this.appendable.append(c);
            } while (++n < n2);
            return n;
        }

        private boolean appendTextInline(int n, int n2, boolean bl) throws IOException {
            int n3;
            assert (this.index < n);
            this.appendLineKeepWhiteSpace(n, n2);
            if (this.index == n) {
                return true;
            }
            int n4 = n3 = bl ? n2 + 1 : n2;
            while (true) {
                if (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                    if (++this.index != n) continue;
                    return false;
                }
                this.appendEssentialNewLine();
                this.appendIndent(n3);
                this.appendLineKeepWhiteSpace(n, n3);
                if (this.index >= n) break;
            }
            assert (this.index == n);
            return false;
        }

        private void appendLineKeepWhiteSpace(int n, int n2) throws IOException {
            assert (this.index < n);
            this.updateNextTag();
            while (true) {
                int n3;
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.appendTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                char c = this.sourceText.charAt(this.index);
                if (c == '\r' && (n3 = this.index + 1) < n && this.sourceText.charAt(n3) == '\n') {
                    this.index += 2;
                    assert (this.index <= n);
                    return;
                }
                if (c == '\n') {
                    ++this.index;
                    assert (this.index <= n);
                    return;
                }
                this.appendable.append(c);
                if (++this.index == n) break;
            }
        }

        private void appendTextCollapseWhiteSpace(int n, int n2) throws IOException {
            assert (this.index < n);
            boolean bl = false;
            this.updateNextTag();
            while (this.index < n) {
                char c;
                while (this.nextTag != null && this.index == this.nextTag.begin) {
                    if (bl) {
                        this.appendable.append(' ');
                        bl = false;
                    }
                    this.appendTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                if (Segment.isWhiteSpace(c = this.sourceText.charAt(this.index++))) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    this.appendable.append(' ');
                    bl = false;
                }
                this.appendable.append(c);
            }
            if (bl) {
                this.appendable.append(' ');
            }
            assert (this.index == n);
        }

        private void appendContentPreformatted(int n, int n2) throws IOException {
            assert (this.index < n);
            this.updateNextTag();
            while (true) {
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.appendTag(this.nextTag, n2, n);
                    if (this.index != n) continue;
                    return;
                }
                this.appendable.append(this.sourceText.charAt(this.index));
                if (++this.index >= n) break;
            }
            assert (this.index == n);
        }

        private void appendTag(Tag tag, int n, int n2) throws IOException {
            CharSequence charSequence;
            int n3;
            assert (this.index == tag.begin);
            assert (this.index < n2);
            this.nextTag = tag.getNextTag();
            int n4 = n3 = tag.end < n2 ? tag.end : n2;
            assert (this.index < n3);
            if (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.CDATA_SECTION || tag.getTagType().isServerTag()) {
                this.appendTextPreserveIndentation(n3, n);
            } else if (this.tidyTags) {
                charSequence = tag.tidy();
                if (tag instanceof StartTag && ((StartTag)tag).getAttributes() != null) {
                    this.appendable.append(charSequence);
                } else {
                    this.appendSpecifiedTextInline(charSequence, n);
                }
                this.index = n3;
            } else {
                this.appendTextInline(n3, n, true);
            }
            if (n2 <= tag.end || !(tag instanceof StartTag)) {
                assert (this.index <= n2);
                return;
            }
            if (tag.name == "script" && !this.indentScriptElements || tag.getTagType().isServerTag()) {
                charSequence = tag.getElement();
                EndTag endTag = ((Element)charSequence).getEndTag();
                if (endTag == null) {
                    assert (this.index <= n2);
                    return;
                }
                int n5 = n2 < endTag.begin ? n2 : endTag.begin;
                boolean bl = true;
                if (this.index != n5) {
                    bl = this.appendTextPreserveIndentation(n5, n);
                }
                if (endTag.begin >= n2) {
                    assert (this.index <= n2);
                    return;
                }
                if (!bl) {
                    this.appendEssentialNewLine();
                    this.appendIndent(n);
                }
                assert (this.index == endTag.begin);
                this.appendTag(endTag, n, n2);
            }
            assert (this.index <= n2);
        }

        private void appendIndent(int n) throws IOException {
            if (!this.removeLineBreaks) {
                for (int i = 0; i < n; ++i) {
                    this.appendable.append(this.indentString);
                }
            }
        }

        private void appendFormattingNewLine() throws IOException {
            if (!this.removeLineBreaks) {
                this.appendable.append(this.newLine);
            }
        }

        private void appendEssentialNewLine() throws IOException {
            this.appendable.append(this.newLine);
        }

        private boolean containsOnlyInlineLevelChildElements(Element element) {
            List<Element> list = element.getChildElements();
            if (list.isEmpty()) {
                return true;
            }
            for (Element element2 : list) {
                String string = element2.getName();
                if (string == "script" || !HTMLElements.getInlineLevelElementNames().contains(string)) {
                    return false;
                }
                if (this.containsOnlyInlineLevelChildElements(element2)) continue;
                return false;
            }
            return true;
        }
    }
}

