/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.net.htmlparser.jericho;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import vuegwt.shaded.net.htmlparser.jericho.CharacterReference;
import vuegwt.shaded.net.htmlparser.jericho.Config;
import vuegwt.shaded.net.htmlparser.jericho.EncodingDetector;
import vuegwt.shaded.net.htmlparser.jericho.Logger;
import vuegwt.shaded.net.htmlparser.jericho.Segment;
import vuegwt.shaded.net.htmlparser.jericho.Source;
import vuegwt.shaded.net.htmlparser.jericho.StartTag;
import vuegwt.shaded.net.htmlparser.jericho.StartTagType;
import vuegwt.shaded.net.htmlparser.jericho.StreamedParseText;
import vuegwt.shaded.net.htmlparser.jericho.StreamedText;
import vuegwt.shaded.net.htmlparser.jericho.Tag;
import vuegwt.shaded.net.htmlparser.jericho.TagType;

public final class StreamedSource
implements Iterable<Segment>,
Closeable {
    private final StreamedText streamedText;
    private final StreamedParseText streamedParseText;
    private final Source source;
    private InternallyCreatedReaderFinalizer internallyCreatedReaderFinalizer = null;
    private final Reader reader;
    private boolean coalescing = false;
    private boolean handleTags = true;
    private Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(false);
    private boolean isInitialised = false;
    private Segment currentSegment = null;
    private Segment nextParsedSegment = START_SEGMENT;
    private boolean isXML;
    private static final boolean assumeNoNestedTags = false;
    private static final Segment START_SEGMENT = new Segment(-1, -1);

    private StreamedSource(Reader reader, boolean bl, String string, String string2, String string3) throws IOException {
        this.reader = reader;
        if (bl) {
            this.internallyCreatedReaderFinalizer = new InternallyCreatedReaderFinalizer(reader);
        }
        this.streamedText = new StreamedText(reader);
        this.streamedParseText = new StreamedParseText(this.streamedText);
        this.source = new Source(this.streamedText, this.streamedParseText, string, string2, string3);
    }

    private StreamedSource(EncodingDetector encodingDetector, boolean bl) throws IOException {
        this(encodingDetector.openReader(), bl, encodingDetector.getEncoding(), encodingDetector.getEncodingSpecificationInfo(), encodingDetector.getPreliminaryEncoding() + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
    }

    public StreamedSource(Reader reader) throws IOException {
        this(reader, false, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null, reader instanceof InputStreamReader ? "InputStreamReader.getEncoding() of constructor argument" : null, null);
    }

    public StreamedSource(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream), false);
    }

    public StreamedSource(URL uRL) throws IOException {
        this(new EncodingDetector(uRL.openConnection()), true);
    }

    public StreamedSource(URLConnection uRLConnection) throws IOException {
        this(new EncodingDetector(uRLConnection), true);
    }

    public StreamedSource(CharSequence charSequence) {
        this.reader = null;
        this.streamedText = new StreamedText(charSequence);
        this.streamedParseText = new StreamedParseText(this.streamedText);
        this.source = new Source(charSequence, this.streamedParseText, null, "Document specified encoding can not be determined automatically from a streamed source", null);
    }

    public StreamedSource setBuffer(char[] cArray) {
        if (this.isInitialised) {
            throw new IllegalStateException("setBuffer() can only be called before iterator() is called");
        }
        this.streamedText.setBuffer(cArray);
        return this;
    }

    public StreamedSource setCoalescing(boolean bl) {
        if (this.isInitialised) {
            throw new IllegalStateException("setPlainTextWriter() can only be called before iterator() is called");
        }
        this.coalescing = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        finally {
            if (this.internallyCreatedReaderFinalizer != null) {
                this.internallyCreatedReaderFinalizer.setReaderToNull();
                this.internallyCreatedReaderFinalizer = null;
            }
        }
    }

    private void closeInternallyCreatedReader() {
        if (this.internallyCreatedReaderFinalizer != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getEncoding() {
        return this.source.getEncoding();
    }

    public String getEncodingSpecificationInfo() {
        return this.source.getEncodingSpecificationInfo();
    }

    public String getPreliminaryEncodingInfo() {
        return this.source.getPreliminaryEncodingInfo();
    }

    @Override
    public Iterator<Segment> iterator() {
        if (this.isInitialised) {
            throw new IllegalStateException("iterator() can only be called once");
        }
        this.isInitialised = true;
        return new StreamedSourceIterator();
    }

    public Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public CharBuffer getCurrentSegmentCharBuffer() {
        return this.streamedText.getCharBuffer(this.currentSegment.getBegin(), this.currentSegment.end);
    }

    public boolean isXML() {
        if (!this.isInitialised) {
            throw new IllegalStateException("isXML() method only available after iterator() has been called");
        }
        return this.isXML;
    }

    public void setLogger(Logger logger) {
        this.source.setLogger(logger);
    }

    public Logger getLogger() {
        return this.source.getLogger();
    }

    public int getBufferSize() {
        return this.streamedText.getBuffer().length;
    }

    public String toString() {
        return super.toString();
    }

    StreamedSource setHandleTags(boolean bl) {
        this.handleTags = bl;
        return this;
    }

    StreamedSource setUnterminatedCharacterReferenceSettings(Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        this.unterminatedCharacterReferenceSettings = unterminatedCharacterReferenceSettings;
        return this;
    }

    StreamedSource setSearchBegin(int n) {
        if (this.isInitialised) {
            throw new IllegalStateException("setSearchBegin() can only be called before iterator() is called");
        }
        int n2 = n - 1;
        this.nextParsedSegment = new Segment(n2, n2);
        return this;
    }

    private static boolean isXML(Segment segment) {
        if (segment == null || !(segment instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)segment;
        if (tag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        return tag.source.getParseText().indexOf("xhtml", tag.begin, tag.end) != -1;
    }

    private static final class InternallyCreatedReaderFinalizer {
        private Reader reader;

        public InternallyCreatedReaderFinalizer(Reader reader) {
            this.reader = reader;
        }

        public void setReaderToNull() {
            this.reader = null;
        }

        protected void finalize() {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StreamedSourceIterator
    implements Iterator<Segment> {
        private final boolean coalescing;
        private final boolean handleTags;
        private Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings;
        private Segment nextSegment;
        private int plainTextSegmentBegin = 0;
        private final char[] charByRef = new char[1];

        public StreamedSourceIterator() {
            this.coalescing = StreamedSource.this.coalescing;
            this.handleTags = StreamedSource.this.handleTags;
            this.unterminatedCharacterReferenceSettings = StreamedSource.this.unterminatedCharacterReferenceSettings;
            this.loadNextParsedSegment();
            StreamedSource.this.isXML = StreamedSource.isXML(StreamedSource.this.nextParsedSegment);
        }

        @Override
        public boolean hasNext() {
            if (this.nextSegment == Tag.NOT_CACHED) {
                this.loadNextParsedSegment();
            }
            return this.nextSegment != null;
        }

        @Override
        public Segment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Segment segment = this.nextSegment;
            this.nextSegment = segment == StreamedSource.this.nextParsedSegment ? Tag.NOT_CACHED : StreamedSource.this.nextParsedSegment;
            StreamedSource.this.streamedText.setMinRequiredBufferBegin(segment instanceof StartTag ? segment.begin : segment.end);
            StreamedSource.this.currentSegment = segment;
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final void loadNextParsedSegment() {
            StreamedSource.this.nextParsedSegment = this.findNextParsedSegment();
            int n = StreamedSource.this.nextParsedSegment != null ? ((StreamedSource)StreamedSource.this).nextParsedSegment.begin : StreamedSource.this.streamedText.length();
            Segment segment = this.nextSegment = this.plainTextSegmentBegin < n ? new Segment(StreamedSource.this.source, this.plainTextSegmentBegin, n) : StreamedSource.this.nextParsedSegment;
            if (StreamedSource.this.nextParsedSegment != null && this.plainTextSegmentBegin < ((StreamedSource)StreamedSource.this).nextParsedSegment.end) {
                this.plainTextSegmentBegin = ((StreamedSource)StreamedSource.this).nextParsedSegment.end;
            }
        }

        private final Segment findNextParsedSegment() {
            try {
                char c;
                int n;
                int n2;
                int n3 = n2 = this.coalescing ? StreamedSource.this.streamedText.getEnd() : StreamedSource.this.streamedText.getBufferOverflowPosition();
                for (n = StreamedSource.this.nextParsedSegment instanceof StartTag && ((StartTag)StreamedSource.this.nextParsedSegment).getTagType() == StartTagType.SERVER_COMMON_COMMENT ? StreamedSource.this.nextParsedSegment.getEnd() : StreamedSource.this.nextParsedSegment.getBegin() + 1; !(n >= n2 || (c = StreamedSource.this.streamedText.charAt(n)) == '\uffff' && StreamedSource.this.streamedText.atEndOfStream()); ++n) {
                    Segment segment;
                    if (c == '&') {
                        if (n < ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] || (segment = CharacterReference.construct(StreamedSource.this.source, n, this.unterminatedCharacterReferenceSettings)) == null) continue;
                        return segment;
                    }
                    if (!this.handleTags || c != '<' || (segment = TagType.getTagAt(StreamedSource.this.source, n, false, false)) == null || ((Tag)segment).isUnregistered()) continue;
                    TagType tagType = ((Tag)segment).getTagType();
                    if (((Tag)segment).end > ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION) {
                        ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && ((Tag)segment).name == "script" && !((StartTag)segment).isEmptyElementTag() ? Integer.MAX_VALUE : ((Tag)segment).end;
                    }
                    return segment;
                }
                if (n < StreamedSource.this.streamedText.getEnd()) {
                    return new Segment(StreamedSource.this.source, this.plainTextSegmentBegin, n);
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                StreamedSource.this.closeInternallyCreatedReader();
                throw bufferOverflowException;
            }
            StreamedSource.this.closeInternallyCreatedReader();
            return null;
        }
    }
}

