/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import vuegwt.shaded.net.htmlparser.jericho.Config;
import vuegwt.shaded.net.htmlparser.jericho.EndTagType;
import vuegwt.shaded.net.htmlparser.jericho.ParseText;
import vuegwt.shaded.net.htmlparser.jericho.Source;
import vuegwt.shaded.net.htmlparser.jericho.StartTagType;
import vuegwt.shaded.net.htmlparser.jericho.TagType;

final class TagTypeRegister {
    private TagTypeRegister parent = null;
    private char ch = '\u0000';
    private TagTypeRegister[] children = null;
    private TagType[] tagTypes = null;
    private static final char NULL_CHAR = '\u0000';
    private static final TagType[] DEFAULT_TAG_TYPES = new TagType[]{StartTagType.UNREGISTERED, StartTagType.NORMAL, StartTagType.COMMENT, StartTagType.MARKUP_DECLARATION, StartTagType.DOCTYPE_DECLARATION, StartTagType.CDATA_SECTION, StartTagType.XML_PROCESSING_INSTRUCTION, StartTagType.XML_DECLARATION, StartTagType.SERVER_COMMON, StartTagType.SERVER_COMMON_ESCAPED, StartTagType.SERVER_COMMON_COMMENT, EndTagType.UNREGISTERED, EndTagType.NORMAL};
    private static TagTypeRegister root = new TagTypeRegister();

    private TagTypeRegister() {
    }

    private static synchronized void add(TagType[] tagTypeArray) {
        for (int i = 0; i < tagTypeArray.length; ++i) {
            TagTypeRegister.add(tagTypeArray[i]);
        }
    }

    public static synchronized void add(TagType tagType) {
        TagTypeRegister tagTypeRegister = root;
        String string = tagType.getStartDelimiter();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            TagTypeRegister tagTypeRegister2 = tagTypeRegister.getChild(c);
            if (tagTypeRegister2 == null) {
                tagTypeRegister2 = new TagTypeRegister();
                tagTypeRegister2.parent = tagTypeRegister;
                tagTypeRegister2.ch = c;
                tagTypeRegister.addChild(tagTypeRegister2);
            }
            tagTypeRegister = tagTypeRegister2;
        }
        tagTypeRegister.addTagType(tagType);
    }

    public static synchronized void remove(TagType tagType) {
        TagTypeRegister tagTypeRegister = root;
        String string = tagType.getStartDelimiter();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            TagTypeRegister tagTypeRegister2 = tagTypeRegister.getChild(c);
            if (tagTypeRegister2 == null) {
                return;
            }
            tagTypeRegister = tagTypeRegister2;
        }
        tagTypeRegister.removeTagType(tagType);
        while (tagTypeRegister != root && tagTypeRegister.tagTypes == null && tagTypeRegister.children == null) {
            tagTypeRegister.parent.removeChild(tagTypeRegister);
            tagTypeRegister = tagTypeRegister.parent;
        }
    }

    public static List<TagType> getList() {
        ArrayList<TagType> arrayList = new ArrayList<TagType>();
        root.addTagTypesToList(arrayList);
        return arrayList;
    }

    private void addTagTypesToList(List<TagType> list) {
        if (this.tagTypes != null) {
            for (int i = this.tagTypes.length - 1; i >= 0; --i) {
                list.add(this.tagTypes[i]);
            }
        }
        if (this.children != null) {
            for (TagTypeRegister tagTypeRegister : this.children) {
                tagTypeRegister.addTagTypesToList(list);
            }
        }
    }

    public static final String getDebugInfo() {
        return root.appendDebugInfo(new StringBuilder(), 0).toString();
    }

    public String toString() {
        return this.appendDebugInfo(new StringBuilder(), 0).toString();
    }

    private StringBuilder appendDebugInfo(StringBuilder stringBuilder, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(" ");
        }
        if (this.ch != '\u0000') {
            stringBuilder.append(this.ch).append(' ');
        }
        if (this.tagTypes != null) {
            stringBuilder.append('(');
            for (TagType tagType : this.tagTypes) {
                stringBuilder.append(tagType.getDescription()).append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(')');
        }
        stringBuilder.append(Config.NewLine);
        if (this.children != null) {
            n2 = n + 1;
            for (TagTypeRegister tagTypeRegister : this.children) {
                tagTypeRegister.appendDebugInfo(stringBuilder, n2);
            }
        }
        return stringBuilder;
    }

    private TagTypeRegister getChild(char c) {
        if (this.children == null) {
            return null;
        }
        if (this.children.length == 1) {
            return this.children[0].ch == c ? this.children[0] : null;
        }
        int n = 0;
        int n2 = this.children.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            char c2 = this.children[n3].ch;
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            return this.children[n3];
        }
        return null;
    }

    private void addChild(TagTypeRegister tagTypeRegister) {
        if (this.children == null) {
            this.children = new TagTypeRegister[]{tagTypeRegister};
        } else {
            int n;
            TagTypeRegister[] tagTypeRegisterArray = new TagTypeRegister[this.children.length + 1];
            for (n = 0; n < this.children.length && this.children[n].ch <= tagTypeRegister.ch; ++n) {
                tagTypeRegisterArray[n] = this.children[n];
            }
            tagTypeRegisterArray[n++] = tagTypeRegister;
            while (n < tagTypeRegisterArray.length) {
                tagTypeRegisterArray[n] = this.children[n - 1];
                ++n;
            }
            this.children = tagTypeRegisterArray;
        }
    }

    private void removeChild(TagTypeRegister tagTypeRegister) {
        if (this.children.length == 1) {
            this.children = null;
            return;
        }
        TagTypeRegister[] tagTypeRegisterArray = new TagTypeRegister[this.children.length - 1];
        int n = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == tagTypeRegister) {
                n = -1;
                continue;
            }
            tagTypeRegisterArray[i + n] = this.children[i];
        }
        this.children = tagTypeRegisterArray;
    }

    private int indexOfTagType(TagType tagType) {
        if (this.tagTypes == null) {
            return -1;
        }
        for (int i = 0; i < this.tagTypes.length; ++i) {
            if (this.tagTypes[i] != tagType) continue;
            return i;
        }
        return -1;
    }

    private void addTagType(TagType tagType) {
        int n = this.indexOfTagType(tagType);
        if (n == -1) {
            if (this.tagTypes == null) {
                this.tagTypes = new TagType[]{tagType};
            } else {
                TagType[] tagTypeArray = new TagType[this.tagTypes.length + 1];
                tagTypeArray[0] = tagType;
                for (int i = 0; i < this.tagTypes.length; ++i) {
                    tagTypeArray[i + 1] = this.tagTypes[i];
                }
                this.tagTypes = tagTypeArray;
            }
        } else {
            for (int i = n; i > 0; --i) {
                this.tagTypes[i] = this.tagTypes[i - 1];
            }
            this.tagTypes[0] = tagType;
        }
    }

    private void removeTagType(TagType tagType) {
        int n;
        int n2 = this.indexOfTagType(tagType);
        if (n2 == -1) {
            return;
        }
        if (this.tagTypes.length == 1) {
            this.tagTypes = null;
            return;
        }
        TagType[] tagTypeArray = new TagType[this.tagTypes.length - 1];
        for (n = 0; n < n2; ++n) {
            tagTypeArray[n] = this.tagTypes[n];
        }
        for (n = n2; n < tagTypeArray.length; ++n) {
            tagTypeArray[n] = this.tagTypes[n + 1];
        }
        this.tagTypes = tagTypeArray;
    }

    static {
        TagTypeRegister.add(DEFAULT_TAG_TYPES);
    }

    static final class ProspectiveTagTypeIterator
    implements Iterator<TagType> {
        private TagTypeRegister cursor;
        private int tagTypeIndex = 0;

        public ProspectiveTagTypeIterator(Source source, int n) {
            ParseText parseText = source.getParseText();
            this.cursor = root;
            int n2 = 0;
            try {
                TagTypeRegister tagTypeRegister;
                while ((tagTypeRegister = this.cursor.getChild(parseText.charAt(n + n2++))) != null) {
                    this.cursor = tagTypeRegister;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            while (this.cursor.tagTypes == null && (this.cursor = this.cursor.parent) != null) {
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public TagType next() {
            TagType[] tagTypeArray = this.cursor.tagTypes;
            TagType tagType = tagTypeArray[this.tagTypeIndex];
            if (++this.tagTypeIndex == tagTypeArray.length) {
                this.tagTypeIndex = 0;
                do {
                    this.cursor = this.cursor.parent;
                } while (this.cursor != null && this.cursor.tagTypes == null);
            }
            return tagType;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

