/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import vuegwt.shaded.org.junit.internal.runners.InitializationError;
import vuegwt.shaded.org.junit.runner.Description;
import vuegwt.shaded.org.junit.runner.Runner;
import vuegwt.shaded.org.junit.runner.notification.Failure;
import vuegwt.shaded.org.junit.runner.notification.RunNotifier;
import vuegwt.shaded.org.junit.runners.model.InvalidTestClassError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingRunner
extends Runner {
    private final List<Throwable> causes;
    private final String classNames;

    public ErrorReportingRunner(Class<?> testClass, Throwable cause) {
        this(cause, testClass);
    }

    public ErrorReportingRunner(Throwable cause, Class<?> ... testClasses) {
        if (testClasses == null || testClasses.length == 0) {
            throw new NullPointerException("Test classes cannot be null or empty");
        }
        for (Class<?> testClass : testClasses) {
            if (testClass != null) continue;
            throw new NullPointerException("Test class cannot be null");
        }
        this.classNames = this.getClassNames(testClasses);
        this.causes = this.getCauses(cause);
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.classNames, new Annotation[0]);
        for (Throwable each : this.causes) {
            description.addChild(this.describeCause());
        }
        return description;
    }

    @Override
    public void run(RunNotifier notifier) {
        for (Throwable each : this.causes) {
            this.runCause(each, notifier);
        }
    }

    private String getClassNames(Class<?> ... testClasses) {
        StringBuilder builder = new StringBuilder();
        for (Class<?> testClass : testClasses) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(testClass.getName());
        }
        return builder.toString();
    }

    private List<Throwable> getCauses(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            return this.getCauses(cause.getCause());
        }
        if (cause instanceof InvalidTestClassError) {
            return Collections.singletonList(cause);
        }
        if (cause instanceof vuegwt.shaded.org.junit.runners.model.InitializationError) {
            return ((vuegwt.shaded.org.junit.runners.model.InitializationError)cause).getCauses();
        }
        if (cause instanceof InitializationError) {
            return ((InitializationError)cause).getCauses();
        }
        return Collections.singletonList(cause);
    }

    private Description describeCause() {
        return Description.createTestDescription(this.classNames, "initializationError", new Annotation[0]);
    }

    private void runCause(Throwable child, RunNotifier notifier) {
        Description description = this.describeCause();
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, child));
        notifier.fireTestFinished(description);
    }
}

