/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import vuegwt.shaded.org.hamcrest.Matcher;
import vuegwt.shaded.org.junit.Assert;
import vuegwt.shaded.org.junit.function.ThrowingRunnable;
import vuegwt.shaded.org.junit.internal.AssumptionViolatedException;
import vuegwt.shaded.org.junit.rules.Verifier;
import vuegwt.shaded.org.junit.runners.model.MultipleFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCollector
extends Verifier {
    private List<Throwable> errors = new ArrayList<Throwable>();

    @Override
    protected void verify() throws Throwable {
        MultipleFailureException.assertEmpty(this.errors);
    }

    public void addError(Throwable error) {
        if (error == null) {
            throw new NullPointerException("Error cannot be null");
        }
        if (error instanceof AssumptionViolatedException) {
            AssertionError e = new AssertionError((Object)error.getMessage());
            ((Throwable)((Object)e)).initCause(error);
            this.errors.add((Throwable)((Object)e));
        } else {
            this.errors.add(error);
        }
    }

    public <T> void checkThat(T value, Matcher<T> matcher) {
        this.checkThat("", value, matcher);
    }

    public <T> void checkThat(final String reason, final T value, final Matcher<T> matcher) {
        this.checkSucceeds(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Assert.assertThat(reason, value, matcher);
                return value;
            }
        });
    }

    public <T> T checkSucceeds(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (AssumptionViolatedException e) {
            AssertionError error = new AssertionError((Object)"Callable threw AssumptionViolatedException");
            ((Throwable)((Object)error)).initCause(e);
            this.addError((Throwable)((Object)error));
            return null;
        }
        catch (Throwable e) {
            this.addError(e);
            return null;
        }
    }

    public void checkThrows(Class<? extends Throwable> expectedThrowable, ThrowingRunnable runnable) {
        try {
            Assert.assertThrows(expectedThrowable, runnable);
        }
        catch (AssertionError e) {
            this.addError((Throwable)((Object)e));
        }
    }
}

