/*
 * Decompiled with CFR 0.152.
 */
package vuegwt.shaded.org.junit.runners;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import vuegwt.shaded.org.junit.internal.AssumptionViolatedException;
import vuegwt.shaded.org.junit.runner.Description;
import vuegwt.shaded.org.junit.runner.Runner;
import vuegwt.shaded.org.junit.runner.notification.Failure;
import vuegwt.shaded.org.junit.runner.notification.RunNotifier;
import vuegwt.shaded.org.junit.runners.Suite;
import vuegwt.shaded.org.junit.runners.model.FrameworkMethod;
import vuegwt.shaded.org.junit.runners.model.InvalidTestClassError;
import vuegwt.shaded.org.junit.runners.model.TestClass;
import vuegwt.shaded.org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParametersFactory;
import vuegwt.shaded.org.junit.runners.parameterized.ParametersRunnerFactory;
import vuegwt.shaded.org.junit.runners.parameterized.TestWithParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized
extends Suite {
    public Parameterized(Class<?> klass) throws Throwable {
        this(klass, new RunnersFactory(klass));
    }

    private Parameterized(Class<?> klass, RunnersFactory runnersFactory) throws Exception {
        super(klass, runnersFactory.createRunners());
        this.validateBeforeParamAndAfterParamMethods(runnersFactory.parameterCount);
    }

    private void validateBeforeParamAndAfterParamMethods(Integer parameterCount) throws InvalidTestClassError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validatePublicStaticVoidMethods(BeforeParam.class, parameterCount, errors);
        this.validatePublicStaticVoidMethods(AfterParam.class, parameterCount, errors);
        if (!errors.isEmpty()) {
            throw new InvalidTestClassError(this.getTestClass().getJavaClass(), errors);
        }
    }

    private void validatePublicStaticVoidMethods(Class<? extends Annotation> annotation, Integer parameterCount, List<Throwable> errors) {
        List<FrameworkMethod> methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod fm : methods) {
            int methodParameterCount;
            fm.validatePublicVoid(true, errors);
            if (parameterCount == null || (methodParameterCount = fm.getMethod().getParameterTypes().length) == 0 || methodParameterCount == parameterCount) continue;
            errors.add(new Exception("Method " + fm.getName() + "() should have 0 or " + parameterCount + " parameter(s)"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunnersFactory {
        private static final ParametersRunnerFactory DEFAULT_FACTORY = new BlockJUnit4ClassRunnerWithParametersFactory();
        private final TestClass testClass;
        private final FrameworkMethod parametersMethod;
        private final List<Object> allParameters;
        private final int parameterCount;
        private final Runner runnerOverride;

        private RunnersFactory(Class<?> klass) throws Throwable {
            List<Object> allParametersResult;
            this.testClass = new TestClass(klass);
            this.parametersMethod = RunnersFactory.getParametersMethod(this.testClass);
            AssumptionViolationRunner assumptionViolationRunner = null;
            try {
                allParametersResult = RunnersFactory.allParameters(this.testClass, this.parametersMethod);
            }
            catch (AssumptionViolatedException e) {
                allParametersResult = Collections.emptyList();
                assumptionViolationRunner = new AssumptionViolationRunner(this.testClass, this.parametersMethod.getName(), e);
            }
            this.allParameters = allParametersResult;
            this.runnerOverride = assumptionViolationRunner;
            this.parameterCount = this.allParameters.isEmpty() ? 0 : RunnersFactory.normalizeParameters(this.allParameters.get(0)).length;
        }

        private List<Runner> createRunners() throws Exception {
            if (this.runnerOverride != null) {
                return Collections.singletonList(this.runnerOverride);
            }
            Parameters parameters = this.parametersMethod.getAnnotation(Parameters.class);
            return Collections.unmodifiableList(this.createRunnersForParameters(this.allParameters, parameters.name(), this.getParametersRunnerFactory()));
        }

        private ParametersRunnerFactory getParametersRunnerFactory() throws InstantiationException, IllegalAccessException {
            UseParametersRunnerFactory annotation = this.testClass.getAnnotation(UseParametersRunnerFactory.class);
            if (annotation == null) {
                return DEFAULT_FACTORY;
            }
            Class<? extends ParametersRunnerFactory> factoryClass = annotation.value();
            return factoryClass.newInstance();
        }

        private TestWithParameters createTestWithNotNormalizedParameters(String pattern, int index, Object parametersOrSingleParameter) {
            Object[] parameters = RunnersFactory.normalizeParameters(parametersOrSingleParameter);
            return this.createTestWithParameters(this.testClass, pattern, index, parameters);
        }

        private static Object[] normalizeParameters(Object parametersOrSingleParameter) {
            Object[] objectArray;
            if (parametersOrSingleParameter instanceof Object[]) {
                objectArray = (Object[])parametersOrSingleParameter;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = parametersOrSingleParameter;
            }
            return objectArray;
        }

        private static List<Object> allParameters(TestClass testClass, FrameworkMethod parametersMethod) throws Throwable {
            Object parameters = parametersMethod.invokeExplosively(null, new Object[0]);
            if (parameters instanceof List) {
                return (List)parameters;
            }
            if (parameters instanceof Collection) {
                return new ArrayList<Object>((Collection)parameters);
            }
            if (parameters instanceof Iterable) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object entry : (Iterable)parameters) {
                    result.add(entry);
                }
                return result;
            }
            if (parameters instanceof Object[]) {
                return Arrays.asList((Object[])parameters);
            }
            throw RunnersFactory.parametersMethodReturnedWrongType(testClass, parametersMethod);
        }

        private static FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
            List<FrameworkMethod> methods = testClass.getAnnotatedMethods(Parameters.class);
            for (FrameworkMethod each : methods) {
                if (!each.isStatic() || !each.isPublic()) continue;
                return each;
            }
            throw new Exception("No public static parameters method on class " + testClass.getName());
        }

        private List<Runner> createRunnersForParameters(Iterable<Object> allParameters, String namePattern, ParametersRunnerFactory runnerFactory) throws Exception {
            try {
                List<TestWithParameters> tests = this.createTestsForParameters(allParameters, namePattern);
                ArrayList<Runner> runners = new ArrayList<Runner>();
                for (TestWithParameters test : tests) {
                    runners.add(runnerFactory.createRunnerForTestWithParameters(test));
                }
                return runners;
            }
            catch (ClassCastException e) {
                throw RunnersFactory.parametersMethodReturnedWrongType(this.testClass, this.parametersMethod);
            }
        }

        private List<TestWithParameters> createTestsForParameters(Iterable<Object> allParameters, String namePattern) throws Exception {
            int i = 0;
            ArrayList<TestWithParameters> children = new ArrayList<TestWithParameters>();
            for (Object parametersOfSingleTest : allParameters) {
                children.add(this.createTestWithNotNormalizedParameters(namePattern, i++, parametersOfSingleTest));
            }
            return children;
        }

        private static Exception parametersMethodReturnedWrongType(TestClass testClass, FrameworkMethod parametersMethod) throws Exception {
            String className = testClass.getName();
            String methodName = parametersMethod.getName();
            String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
            return new Exception(message);
        }

        private TestWithParameters createTestWithParameters(TestClass testClass, String pattern, int index, Object[] parameters) {
            String finalPattern = pattern.replaceAll("\\{index\\}", Integer.toString(index));
            String name = MessageFormat.format(finalPattern, parameters);
            return new TestWithParameters("[" + name + "]", testClass, Arrays.asList(parameters));
        }
    }

    private static class AssumptionViolationRunner
    extends Runner {
        private final Description description;
        private final AssumptionViolatedException exception;

        AssumptionViolationRunner(TestClass testClass, String methodName, AssumptionViolatedException exception) {
            this.description = Description.createTestDescription(testClass.getJavaClass(), methodName + "() assumption violation");
            this.exception = exception;
        }

        public Description getDescription() {
            return this.description;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestAssumptionFailed(new Failure(this.description, this.exception));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AfterParam {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BeforeParam {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Target(value={ElementType.TYPE})
    public static @interface UseParametersRunnerFactory {
        public Class<? extends ParametersRunnerFactory> value() default BlockJUnit4ClassRunnerWithParametersFactory.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "{index}";
    }
}

