/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.management.implementation.polling.AzureAsyncOperationData;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.LocationData;
import com.azure.core.management.implementation.polling.PollingType;
import com.azure.core.management.implementation.polling.ProvisioningStateData;
import com.azure.core.management.implementation.polling.SynchronouslyFailedLroData;
import com.azure.core.management.implementation.polling.SynchronouslySucceededLroData;
import com.azure.core.management.implementation.polling.Util;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;

public final class PollingState {
    @JsonIgnore
    private static final ClientLogger LOGGER = new ClientLogger(PollingState.class);
    @JsonIgnore
    private static final String KEY = "3c7cac4f-acbb-4671-b6b4-edf2d3010041";
    @JsonIgnore
    private SerializerAdapter serializerAdapter;
    @JsonProperty(value="pollingType", required=true)
    private PollingType pollingType;
    @JsonProperty(value="lroResponseStatusCode", required=true)
    private int lroResponseStatusCode;
    @JsonProperty(value="lroRequestMethod", required=true)
    private HttpMethod lroRequestMethod;
    @JsonProperty(value="lroOperationUri", required=true)
    private URL lroOperationUri;
    @JsonProperty(value="pollDelay")
    private Duration pollDelay;
    @JsonProperty(value="asyncOperationData")
    private AzureAsyncOperationData azureAsyncOperationData;
    @JsonProperty(value="locationData")
    private LocationData locationData;
    @JsonProperty(value="provisioningData")
    private ProvisioningStateData provisioningStateData;
    @JsonProperty(value="synchronouslySucceededLroData")
    private SynchronouslySucceededLroData synchronouslySucceededLroData;
    @JsonProperty(value="synchronouslyFailedLroData")
    private SynchronouslyFailedLroData synchronouslyFailedLroData;
    @JsonProperty(value="lastResponseBody")
    private String lastResponseBody;

    PollingState() {
    }

    public static PollingState create(SerializerAdapter serializerAdapter, HttpRequest lroHttpRequest, int lroResponseStatusCode, HttpHeaders lroResponseHeaders, String lroResponseBody) {
        HttpMethod httpMethod = lroHttpRequest.getHttpMethod();
        if (httpMethod != HttpMethod.PUT && httpMethod != HttpMethod.PATCH && httpMethod != HttpMethod.POST && httpMethod != HttpMethod.DELETE) {
            throw new IllegalArgumentException("Long-running-operation supported only for PUT, PATCH, POST or DELETE verb.");
        }
        PollingState pollingState = new PollingState(serializerAdapter, lroHttpRequest.getHttpMethod(), lroHttpRequest.getUrl(), lroResponseStatusCode, PollingState.getRetryAfter(lroResponseHeaders), lroResponseBody);
        switch (pollingState.lroResponseStatusCode) {
            case 200: {
                return pollingState.initializeDataFor200StatusCode(lroResponseHeaders, lroResponseBody);
            }
            case 201: {
                return pollingState.initializeDataFor201StatusCode(lroResponseHeaders, lroResponseBody);
            }
            case 202: {
                return pollingState.initializeDataFor202StatusCode(lroResponseHeaders, lroResponseBody);
            }
            case 204: {
                return pollingState.initializeDataFor204StatusCode();
            }
        }
        return pollingState.initializeDataForUnknownStatusCode(lroResponseHeaders, lroResponseBody);
    }

    public static <T> PollingState from(SerializerAdapter serializerAdapter, PollingContext<T> context) {
        Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null.");
        String value = context.getData(KEY);
        if (value == null || "".equalsIgnoreCase(value)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The provided context does not contain serialized PollingState."));
        }
        try {
            PollingState pollingState = (PollingState)serializerAdapter.deserialize(value, PollingState.class, SerializerEncoding.JSON);
            return pollingState.setSerializer(serializerAdapter);
        }
        catch (IOException ioe) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to deserialize '" + value + "' to PollingState.", ioe));
        }
    }

    public static PollingState from(SerializerAdapter serializerAdapter, String value) {
        Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null.");
        if (value == null || "".equalsIgnoreCase(value)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'value' is required"));
        }
        try {
            PollingState pollingState = (PollingState)serializerAdapter.deserialize(value, PollingState.class, SerializerEncoding.JSON);
            return pollingState.setSerializer(serializerAdapter);
        }
        catch (IOException ioe) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to deserialize '" + value, ioe));
        }
    }

    public <T> void store(PollingContext<T> context) {
        try {
            context.setData(KEY, this.serializerAdapter.serialize((Object)this, SerializerEncoding.JSON));
        }
        catch (IOException ioe) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to serialize the PollingState.", ioe));
        }
    }

    public LongRunningOperationStatus getOperationStatus() {
        switch (this.pollingType) {
            case AZURE_ASYNC_OPERATION_POLL: {
                return this.toLongRunningOperationStatus(this.azureAsyncOperationData.getProvisioningState());
            }
            case LOCATION_POLL: {
                return this.toLongRunningOperationStatus(this.locationData.getProvisioningState());
            }
            case PROVISIONING_STATE_POLL: {
                return this.toLongRunningOperationStatus(this.provisioningStateData.getProvisioningState());
            }
            case SYNCHRONOUSLY_SUCCEEDED_LRO_NO_POLL: {
                return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
            case SYNCHRONOUSLY_FAILED_LRO_NO_POLL: {
                return LongRunningOperationStatus.FAILED;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unknown pollingType:" + (Object)((Object)this.pollingType)));
    }

    URL getPollUrl() {
        switch (this.pollingType) {
            case AZURE_ASYNC_OPERATION_POLL: {
                return this.azureAsyncOperationData.getPollUrl();
            }
            case LOCATION_POLL: {
                return this.locationData.getPollUrl();
            }
            case PROVISIONING_STATE_POLL: {
                return this.provisioningStateData.getPollUrl();
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("PollUrl not available for the pollingType:" + (Object)((Object)this.pollingType)));
    }

    public Duration getPollDelay() {
        return this.pollDelay;
    }

    Error getSynchronouslyFailedLroError() {
        return this.pollingType == PollingType.SYNCHRONOUSLY_FAILED_LRO_NO_POLL ? this.synchronouslyFailedLroData : null;
    }

    Error getPollError() {
        switch (this.pollingType) {
            case AZURE_ASYNC_OPERATION_POLL: {
                return this.azureAsyncOperationData.getPollError();
            }
            case LOCATION_POLL: {
                return this.locationData.getPollError();
            }
            case PROVISIONING_STATE_POLL: {
                return this.provisioningStateData.getPollError();
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("PollError not available for the pollingType:" + (Object)((Object)this.pollingType)));
    }

    FinalResult getFinalResult() {
        switch (this.pollingType) {
            case AZURE_ASYNC_OPERATION_POLL: {
                return this.azureAsyncOperationData.getFinalResult();
            }
            case LOCATION_POLL: {
                return this.locationData.getFinalResult();
            }
            case PROVISIONING_STATE_POLL: {
                return this.provisioningStateData.getFinalResult();
            }
            case SYNCHRONOUSLY_SUCCEEDED_LRO_NO_POLL: {
                return this.synchronouslySucceededLroData.getFinalResult();
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("FinalResult not available for the pollingType:" + (Object)((Object)this.pollingType)));
    }

    String getLastResponseBody() {
        return this.lastResponseBody;
    }

    PollingState update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody) {
        switch (this.pollingType) {
            case AZURE_ASYNC_OPERATION_POLL: {
                this.azureAsyncOperationData.update(pollResponseStatusCode, pollResponseHeaders, pollResponseBody, this.serializerAdapter);
                break;
            }
            case LOCATION_POLL: {
                this.locationData.update(pollResponseStatusCode, pollResponseHeaders, pollResponseBody);
                break;
            }
            case PROVISIONING_STATE_POLL: {
                this.provisioningStateData.update(pollResponseStatusCode, pollResponseHeaders, pollResponseBody, this.serializerAdapter);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("update not available for the pollingType:" + (Object)((Object)this.pollingType)));
            }
        }
        this.pollDelay = PollingState.getRetryAfter(pollResponseHeaders);
        this.lastResponseBody = pollResponseBody;
        return this;
    }

    private PollingState setSerializer(SerializerAdapter serializer) {
        this.serializerAdapter = serializer;
        return this;
    }

    private LongRunningOperationStatus toLongRunningOperationStatus(String value) {
        boolean isCompleted;
        boolean bl = isCompleted = "Succeeded".equalsIgnoreCase(value) || "Failed".equalsIgnoreCase(value) || "Canceled".equalsIgnoreCase(value);
        if (isCompleted && "Succeeded".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        }
        if (isCompleted && "Failed".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.FAILED;
        }
        if (isCompleted && "Canceled".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.USER_CANCELLED;
        }
        if ("InProgress".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.IN_PROGRESS;
        }
        return LongRunningOperationStatus.fromString((String)value, (boolean)isCompleted);
    }

    private boolean isPutOrPatchLro() {
        return this.lroRequestMethod == HttpMethod.PUT || this.lroRequestMethod == HttpMethod.PATCH;
    }

    private boolean isPostOrDeleteLro() {
        return this.lroRequestMethod == HttpMethod.POST || this.lroRequestMethod == HttpMethod.DELETE;
    }

    private PollingState setData(AzureAsyncOperationData data) {
        this.pollingType = PollingType.AZURE_ASYNC_OPERATION_POLL;
        this.azureAsyncOperationData = data;
        return this;
    }

    private PollingState setData(LocationData data) {
        this.pollingType = PollingType.LOCATION_POLL;
        this.locationData = data;
        return this;
    }

    private PollingState setData(ProvisioningStateData data) {
        this.pollingType = PollingType.PROVISIONING_STATE_POLL;
        this.provisioningStateData = data;
        return this;
    }

    private PollingState setData(SynchronouslySucceededLroData data) {
        this.pollingType = PollingType.SYNCHRONOUSLY_SUCCEEDED_LRO_NO_POLL;
        this.synchronouslySucceededLroData = data;
        return this;
    }

    private PollingState setData(SynchronouslyFailedLroData data) {
        this.pollingType = PollingType.SYNCHRONOUSLY_FAILED_LRO_NO_POLL;
        this.synchronouslyFailedLroData = data;
        return this;
    }

    private PollingState initializeDataFor200StatusCode(HttpHeaders lroResponseHeaders, String lroResponseBody) {
        this.assertStatusCode(200);
        if (this.isPutOrPatchLro()) {
            String value = ProvisioningStateData.tryParseProvisioningState(lroResponseBody, this.serializerAdapter);
            if (value != null && !"Succeeded".equalsIgnoreCase(value)) {
                URL azAsyncOpUrl = Util.getAzureAsyncOperationUrl(lroResponseHeaders, LOGGER, true);
                if (azAsyncOpUrl == null) {
                    return this.setData(new ProvisioningStateData(this.lroOperationUri, value));
                }
                return this.setData(new AzureAsyncOperationData(this.lroRequestMethod, this.lroOperationUri, azAsyncOpUrl, null));
            }
            return this.setData(new SynchronouslySucceededLroData(lroResponseBody));
        }
        return this.setData(new SynchronouslySucceededLroData(lroResponseBody));
    }

    private PollingState initializeDataFor201StatusCode(HttpHeaders lroResponseHeaders, String lroResponseBody) {
        this.assertStatusCode(201);
        URL azAsyncOpUrl = Util.getAzureAsyncOperationUrl(lroResponseHeaders, LOGGER, true);
        URL locationUrl = Util.getLocationUrl(lroResponseHeaders, LOGGER, true);
        if (azAsyncOpUrl != null) {
            String value;
            if (this.isPostOrDeleteLro()) {
                LOGGER.info("The LRO {}:{}, received StatusCode:201, AzureAsyncOperation:{}. {}", new Object[]{this.lroRequestMethod, this.lroOperationUri, azAsyncOpUrl, "<POST|DELETE, 201, AzureAsyncOperation> combination violate ARM guideline, defaulting to async operation based polling."});
            }
            if (!"Succeeded".equalsIgnoreCase(value = ProvisioningStateData.tryParseProvisioningState(lroResponseBody, this.serializerAdapter))) {
                return this.setData(new AzureAsyncOperationData(this.lroRequestMethod, this.lroOperationUri, azAsyncOpUrl, locationUrl));
            }
            return this.setData(new SynchronouslySucceededLroData(lroResponseBody));
        }
        if (locationUrl != null) {
            LOGGER.info("The LRO {}:{}, received StatusCode:201, Location:{} without AzureAsyncOperation. {}", new Object[]{this.lroRequestMethod, this.lroOperationUri, locationUrl, "Location will be ignored on <201, Location, No AzureAsyncOperation> combination."});
        }
        if (this.isPutOrPatchLro()) {
            String value = ProvisioningStateData.tryParseProvisioningState(lroResponseBody, this.serializerAdapter);
            if (value != null && !"Succeeded".equalsIgnoreCase(value)) {
                return this.setData(new ProvisioningStateData(this.lroOperationUri, value));
            }
            return this.setData(new SynchronouslySucceededLroData(lroResponseBody));
        }
        return this.setData(new SynchronouslySucceededLroData(lroResponseBody));
    }

    private PollingState initializeDataFor202StatusCode(HttpHeaders lroResponseHeaders, String lroResponseBody) {
        this.assertStatusCode(202);
        URL azAsyncOpUrl = Util.getAzureAsyncOperationUrl(lroResponseHeaders, LOGGER, true);
        URL locationUrl = Util.getLocationUrl(lroResponseHeaders, LOGGER, true);
        if (azAsyncOpUrl != null) {
            return this.setData(new AzureAsyncOperationData(this.lroRequestMethod, this.lroOperationUri, azAsyncOpUrl, locationUrl));
        }
        if (locationUrl != null) {
            return this.setData(new LocationData(locationUrl));
        }
        return this.setData(new SynchronouslyFailedLroData("Response with status code 202 does not contain an Azure-AsyncOperation or Location header", 202, lroResponseHeaders.toMap(), lroResponseBody));
    }

    private PollingState initializeDataFor204StatusCode() {
        this.assertStatusCode(204);
        return this.setData(new SynchronouslySucceededLroData(null));
    }

    private PollingState initializeDataForUnknownStatusCode(HttpHeaders lroResponseHeaders, String lroResponseBody) {
        return this.setData(new SynchronouslyFailedLroData("Response StatusCode: " + this.lroResponseStatusCode, this.lroResponseStatusCode, lroResponseHeaders.toMap(), lroResponseBody));
    }

    private void assertStatusCode(int statusCode) {
        if (this.lroResponseStatusCode != statusCode) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Expected statusCode" + statusCode + "found" + this.lroResponseStatusCode));
        }
    }

    private static Duration getRetryAfter(HttpHeaders headers) {
        String value = headers.getValue(HttpHeaderName.RETRY_AFTER);
        if (value != null) {
            try {
                long retryAfterInSeconds = Long.parseLong(value);
                if (retryAfterInSeconds >= 0L) {
                    return Duration.ofSeconds(retryAfterInSeconds);
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Unable to decode '" + value + "' to Long", nfe));
            }
        }
        return null;
    }

    private PollingState(SerializerAdapter serializerAdapter, HttpMethod lroRequestMethod, URL lroOperationUri, int lroResponseStatusCode, Duration pollDelay, String lroResponseBody) {
        this.serializerAdapter = Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null");
        this.lroRequestMethod = Objects.requireNonNull(lroRequestMethod, "'lroRequestMethod' cannot be null");
        this.lroOperationUri = Objects.requireNonNull(lroOperationUri, "'lroOperationUri' cannot be null");
        this.lroResponseStatusCode = lroResponseStatusCode;
        this.pollDelay = pollDelay;
        this.lastResponseBody = lroResponseBody;
    }
}

