/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import java.time.OffsetDateTime;

public final class ConfigurationClient {
    private final ConfigurationAsyncClient client;

    ConfigurationClient(ConfigurationAsyncClient client) {
        this.client = client;
    }

    public ConfigurationSetting addConfigurationSetting(String key, String label, String value) {
        return (ConfigurationSetting)this.addConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), Context.NONE).getValue();
    }

    public Response<ConfigurationSetting> addConfigurationSettingWithResponse(ConfigurationSetting setting, Context context) {
        return (Response)this.client.addConfigurationSetting(setting, context).block();
    }

    public ConfigurationSetting setConfigurationSetting(String key, String label, String value) {
        return (ConfigurationSetting)this.setConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), false, Context.NONE).getValue();
    }

    public Response<ConfigurationSetting> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        return (Response)this.client.setConfigurationSetting(setting, ifUnchanged, context).block();
    }

    public ConfigurationSetting getConfigurationSetting(String key, String label) {
        return this.getConfigurationSetting(key, label, null);
    }

    public ConfigurationSetting getConfigurationSetting(String key, String label, OffsetDateTime acceptDateTime) {
        return (ConfigurationSetting)this.client.getConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label), acceptDateTime, false, Context.NONE).flatMap(FluxUtil::toMono).block();
    }

    public Response<ConfigurationSetting> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean ifChanged, Context context) {
        return (Response)this.client.getConfigurationSetting(setting, acceptDateTime, ifChanged, context).block();
    }

    public ConfigurationSetting deleteConfigurationSetting(String key, String label) {
        return (ConfigurationSetting)this.deleteConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), false, Context.NONE).getValue();
    }

    public Response<ConfigurationSetting> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        return (Response)this.client.deleteConfigurationSetting(setting, ifUnchanged, context).block();
    }

    public ConfigurationSetting setReadOnly(String key, String label, boolean isReadOnly) {
        return (ConfigurationSetting)this.setReadOnlyWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), isReadOnly, Context.NONE).getValue();
    }

    public Response<ConfigurationSetting> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly, Context context) {
        return (Response)this.client.setReadOnly(setting, isReadOnly, context).block();
    }

    public PagedIterable<ConfigurationSetting> listConfigurationSettings(SettingSelector selector) {
        return this.listConfigurationSettings(selector, Context.NONE);
    }

    public PagedIterable<ConfigurationSetting> listConfigurationSettings(SettingSelector selector, Context context) {
        return new PagedIterable(this.client.listConfigurationSettings(selector, context));
    }

    public PagedIterable<ConfigurationSetting> listRevisions(SettingSelector selector) {
        return this.listRevisions(selector, Context.NONE);
    }

    public PagedIterable<ConfigurationSetting> listRevisions(SettingSelector selector, Context context) {
        return new PagedIterable(this.client.listRevisions(selector, context));
    }
}

