/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationServiceVersion;
import com.azure.data.appconfiguration.implementation.ConfigurationClientCredentials;
import com.azure.data.appconfiguration.implementation.ConfigurationCredentialsPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ConfigurationAsyncClient.class, ConfigurationClient.class})
public final class ConfigurationClientBuilder {
    private static final String ECHO_REQUEST_ID_HEADER = "x-ms-return-client-request-id";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_HEADER_VALUE = "application/vnd.microsoft.azconfig.kv+json";
    private static final String APP_CONFIG_PROPERTIES = "azure-data-appconfiguration.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private final ClientLogger logger = new ClientLogger(ConfigurationClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private final HttpHeaders headers;
    private final Map<String, String> properties;
    private ConfigurationClientCredentials credential;
    private TokenCredential tokenCredential;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private HttpPipelinePolicy retryPolicy;
    private Configuration configuration;
    private ConfigurationServiceVersion version;

    public ConfigurationClientBuilder() {
        this.properties = CoreUtils.getProperties((String)APP_CONFIG_PROPERTIES);
        this.headers = new HttpHeaders().put(ECHO_REQUEST_ID_HEADER, "true").put(CONTENT_TYPE_HEADER, CONTENT_TYPE_HEADER_VALUE).put(ACCEPT_HEADER, ACCEPT_HEADER_VALUE);
    }

    public ConfigurationClient buildClient() {
        return new ConfigurationClient(this.buildAsyncClient());
    }

    public ConfigurationAsyncClient buildAsyncClient() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ConfigurationServiceVersion serviceVersion = this.version != null ? this.version : ConfigurationServiceVersion.getLatest();
        String buildEndpoint = this.endpoint;
        if (this.tokenCredential == null) {
            buildEndpoint = this.getBuildEndpoint();
        }
        Objects.requireNonNull(buildEndpoint, "'Endpoint' is required and can not be null.");
        if (this.pipeline != null) {
            return new ConfigurationAsyncClient(buildEndpoint, this.pipeline, serviceVersion);
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        policies.add(new AddHeadersPolicy(this.headers));
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{String.format("%s/.default", buildEndpoint)}));
        } else if (this.credential != null) {
            policies.add(new ConfigurationCredentialsPolicy(this.credential));
        } else {
            this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new ConfigurationAsyncClient(buildEndpoint, pipeline, serviceVersion);
    }

    public ConfigurationClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL"));
        }
        this.endpoint = endpoint;
        return this;
    }

    public ConfigurationClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        if (connectionString.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot be an empty string."));
        }
        try {
            this.credential = new ConfigurationClientCredentials(connectionString);
        }
        catch (InvalidKeyException err) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The secret contained within the connection string is invalid and cannot instantiate the HMAC-SHA256 algorithm.", err));
        }
        catch (NoSuchAlgorithmException err) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("HMAC-SHA256 MAC algorithm cannot be instantiated.", err));
        }
        this.endpoint = this.credential.getBaseUri();
        return this;
    }

    public ConfigurationClientBuilder credential(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential);
        this.tokenCredential = tokenCredential;
        return this;
    }

    public ConfigurationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public ConfigurationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.policies.add(policy);
        return this;
    }

    public ConfigurationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.", new Object[0]);
        }
        this.httpClient = client;
        return this;
    }

    public ConfigurationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.", new Object[0]);
        }
        this.pipeline = pipeline;
        return this;
    }

    public ConfigurationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ConfigurationClientBuilder retryPolicy(HttpPipelinePolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ConfigurationClientBuilder serviceVersion(ConfigurationServiceVersion version) {
        this.version = version;
        return this;
    }

    private String getBuildEndpoint() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (this.credential != null) {
            return this.credential.getBaseUri();
        }
        return null;
    }
}

