/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.template;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.CachingTokenCredentialProvider;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import com.azure.identity.extensions.implementation.enums.AuthProperty;
import com.azure.identity.extensions.implementation.token.AccessTokenResolver;
import com.azure.identity.extensions.implementation.token.AccessTokenResolverOptions;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class AzureAuthenticationTemplate {
    private static final ClientLogger LOGGER = new ClientLogger(AzureAuthenticationTemplate.class);
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private TokenCredentialProvider tokenCredentialProvider;
    private AccessTokenResolver accessTokenResolver;
    private long accessTokenTimeoutInSeconds;

    public AzureAuthenticationTemplate() {
        this.tokenCredentialProvider = null;
        this.accessTokenResolver = null;
    }

    public AzureAuthenticationTemplate(TokenCredentialProvider tokenCredentialProvider, AccessTokenResolver accessTokenResolver) {
        this.tokenCredentialProvider = tokenCredentialProvider;
        this.accessTokenResolver = accessTokenResolver;
    }

    public void init(Properties properties) {
        if (this.isInitialized.compareAndSet(false, true)) {
            LOGGER.verbose("Initializing AzureAuthenticationTemplate.");
            if (this.getTokenCredentialProvider() == null) {
                TokenCredentialProviderOptions options = new TokenCredentialProviderOptions(properties);
                this.tokenCredentialProvider = TokenCredentialProvider.createDefault(options);
                if (Boolean.TRUE.equals(AuthProperty.TOKEN_CREDENTIAL_CACHE_ENABLED.getBoolean(properties))) {
                    this.tokenCredentialProvider = new CachingTokenCredentialProvider(options, this.tokenCredentialProvider);
                }
            }
            if (this.getAccessTokenResolver() == null) {
                this.accessTokenResolver = AccessTokenResolver.createDefault(new AccessTokenResolverOptions(properties));
            }
            if (properties.containsKey(AuthProperty.GET_TOKEN_TIMEOUT.getPropertyKey())) {
                this.accessTokenTimeoutInSeconds = Long.parseLong(AuthProperty.GET_TOKEN_TIMEOUT.get(properties));
            } else {
                this.accessTokenTimeoutInSeconds = 30L;
                LOGGER.verbose("Use default access token timeout: {} seconds.", new Object[]{this.accessTokenTimeoutInSeconds});
            }
            LOGGER.verbose("Initialized AzureAuthenticationTemplate.");
        } else {
            LOGGER.info("AzureAuthenticationTemplate has already initialized.");
        }
    }

    public Mono<String> getTokenAsPasswordAsync() {
        if (!this.isInitialized.get()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("must call init() first"));
        }
        return Mono.fromSupplier((Supplier)this.getTokenCredentialProvider()).flatMap((Function)this.getAccessTokenResolver()).filter(token -> !token.isExpired()).map(AccessToken::getToken);
    }

    public String getTokenAsPassword() {
        return (String)this.getTokenAsPasswordAsync().block(this.getBlockTimeout());
    }

    AccessTokenResolver getAccessTokenResolver() {
        return this.accessTokenResolver;
    }

    TokenCredentialProvider getTokenCredentialProvider() {
        return this.tokenCredentialProvider;
    }

    Duration getBlockTimeout() {
        return Duration.ofSeconds(this.accessTokenTimeoutInSeconds);
    }

    AtomicBoolean getIsInitialized() {
        return this.isInitialized;
    }
}

