/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.msalextensions;

import com.azure.identity.implementation.msalextensions.CacheLockNotObtainedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;

public class CacheLock {
    private int lockfileRetryWait = 100;
    private int lockfileRetryCount = 60000 / this.lockfileRetryWait;
    private File lockFile;
    private FileOutputStream fos;
    private FileChannel channel;
    private FileLock lock = null;
    private File debugFile;
    private String debugFilename = Paths.get(System.getProperty("user.dir"), "target", "debug").toString();
    private final boolean debugFlag;

    public CacheLock(String lockfileName) {
        this.lockFile = new File(lockfileName);
        this.debugFlag = false;
    }

    public CacheLock(String lockfileName, String id) {
        this.lockFile = new File(lockfileName);
        this.debugFile = new File(this.debugFilename + id + ".txt");
        this.debugFlag = true;
    }

    public void lock() throws CacheLockNotObtainedException {
        try {
            for (int tryCount = 0; tryCount < this.lockfileRetryCount; ++tryCount) {
                if (this.debugFlag) {
                    try {
                        this.fos = new FileOutputStream(this.debugFile, true);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.lockFile.exists()) {
                    if (this.lockFile.createNewFile()) {
                        this.lockFile.deleteOnExit();
                        try {
                            this.channel = new RandomAccessFile(this.lockFile, "rw").getChannel();
                            this.lock = this.channel.lock();
                            this.printToFileIfDebug("Locked!\n");
                            return;
                        }
                        catch (OverlappingFileLockException e) {
                            this.printToFileIfDebug("overlap error\n");
                        }
                        catch (Exception e) {
                            this.printToFileIfDebug("something else went wrong.. general exception\n");
                        }
                    } else {
                        this.printToFileIfDebug("lockfile already exists\n");
                    }
                } else {
                    this.printToFileIfDebug("create new file failed");
                }
                this.printToFileIfDebug("retry\n");
                try {
                    Random rand = new Random(System.currentTimeMillis());
                    int offset = rand.nextInt(10);
                    Thread.sleep(this.lockfileRetryWait + offset);
                    continue;
                }
                catch (InterruptedException ex) {
                    this.printToFileIfDebug("thread sleep issue");
                }
            }
        }
        catch (IOException e) {
            this.printToFileIfDebug("general exception, not sure what happened here...no retries\n");
        }
        throw new CacheLockNotObtainedException("Maximum retries used; could not obtain CacheLock");
    }

    public boolean unlock() {
        try {
            this.lock.release();
            this.channel.close();
            Files.delete(Paths.get(this.lockFile.getPath(), new String[0]));
            this.printToFileIfDebug("unlocked\n");
            return true;
        }
        catch (IOException e) {
            this.printToFileIfDebug("not unlocked... IOException: " + e.getMessage());
            return false;
        }
    }

    private void printToFileIfDebug(String message) {
        if (this.debugFlag && this.fos != null) {
            try {
                this.fos.write(message.getBytes("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

