/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import java.time.Duration;

public final class CoreToCodegenBridgeUtils {
    public static String durationToStringWithDays(Duration duration) {
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        if (duration == null) {
            return null;
        }
        if (duration.isZero()) {
            return "PT0S";
        }
        StringBuilder builder = new StringBuilder();
        if (duration.isNegative()) {
            builder.append("-P");
            duration = duration.negated();
        } else {
            builder.append('P');
        }
        long days = duration.toDays();
        if (days > 0L) {
            builder.append(days);
            builder.append('D');
            duration = duration.minusDays(days);
        }
        if ((hours = duration.toHours()) > 0L) {
            builder.append('T');
            builder.append(hours);
            builder.append('H');
            duration = duration.minusHours(hours);
        }
        if ((minutes = duration.toMinutes()) > 0L) {
            if (hours == 0L) {
                builder.append('T');
            }
            builder.append(minutes);
            builder.append('M');
            duration = duration.minusMinutes(minutes);
        }
        if ((seconds = duration.getSeconds()) > 0L) {
            if (hours == 0L && minutes == 0L) {
                builder.append('T');
            }
            builder.append(seconds);
            duration = duration.minusSeconds(seconds);
        }
        if ((milliseconds = duration.toMillis()) > 0L) {
            if (hours == 0L && minutes == 0L && seconds == 0L) {
                builder.append("T");
            }
            if (seconds == 0L) {
                builder.append("0");
            }
            builder.append('.');
            if (milliseconds <= 99L) {
                builder.append('0');
                if (milliseconds <= 9L) {
                    builder.append('0');
                }
            }
            while (milliseconds % 10L == 0L) {
                milliseconds /= 10L;
            }
            builder.append(milliseconds);
        }
        if (seconds > 0L || milliseconds > 0L) {
            builder.append('S');
        }
        return builder.toString();
    }
}

