/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class NamespacesImpl {
    private final NamespacesService service;
    private final ServiceBusManagementClientImpl client;

    NamespacesImpl(ServiceBusManagementClientImpl client) {
        this.service = (NamespacesService)RestProxy.create(NamespacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NamespacePropertiesEntryImpl>> getWithResponseAsync() {
        return FluxUtil.withContext(context -> this.getWithResponseAsync((Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NamespacePropertiesEntryImpl>> getWithResponseAsync(Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NamespacePropertiesEntryImpl> getAsync() {
        return this.getWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((NamespacePropertiesEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NamespacePropertiesEntryImpl> getAsync(Context context) {
        return this.getWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((NamespacePropertiesEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespacePropertiesEntryImpl> getWithResponse(Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespacePropertiesEntryImpl get() {
        return (NamespacePropertiesEntryImpl)this.getWithResponse(Context.NONE).getValue();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    public static interface NamespacesService {
        @Get(value="/$namespaceinfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<NamespacePropertiesEntryImpl>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/$namespaceinfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<NamespacePropertiesEntryImpl> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

