/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class RulesImpl {
    private final RulesService service;
    private final ServiceBusManagementClientImpl client;

    RulesImpl(ServiceBusManagementClientImpl client) {
        this.service = (RulesService)RestProxy.create(RulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> getWithResponseAsync(String topicName, String subscriptionName, String ruleName, Boolean enrich) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(topicName, subscriptionName, ruleName, enrich, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> getWithResponseAsync(String topicName, String subscriptionName, String ruleName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.get(this.client.getEndpoint(), topicName, subscriptionName, ruleName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> getAsync(String topicName, String subscriptionName, String ruleName, Boolean enrich) {
        return this.getWithResponseAsync(topicName, subscriptionName, ruleName, enrich).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> getAsync(String topicName, String subscriptionName, String ruleName, Boolean enrich, Context context) {
        return this.getWithResponseAsync(topicName, subscriptionName, ruleName, enrich, context).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleDescriptionEntryImpl> getWithResponse(String topicName, String subscriptionName, String ruleName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.getSync(this.client.getEndpoint(), topicName, subscriptionName, ruleName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleDescriptionEntryImpl get(String topicName, String subscriptionName, String ruleName, Boolean enrich) {
        return (RuleDescriptionEntryImpl)this.getWithResponse(topicName, subscriptionName, ruleName, enrich, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> putWithResponseAsync(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch) {
        return FluxUtil.withContext(context -> this.putWithResponseAsync(topicName, subscriptionName, ruleName, requestBody, ifMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> putWithResponseAsync(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.put(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> putAsync(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch) {
        return this.putWithResponseAsync(topicName, subscriptionName, ruleName, requestBody, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> putAsync(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch, Context context) {
        return this.putWithResponseAsync(topicName, subscriptionName, ruleName, requestBody, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleDescriptionEntryImpl> putWithResponse(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.putSync(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleDescriptionEntryImpl put(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch) {
        return (RuleDescriptionEntryImpl)this.putWithResponse(topicName, subscriptionName, ruleName, requestBody, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> deleteWithResponseAsync(String topicName, String subscriptionName, String ruleName) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(topicName, subscriptionName, ruleName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionEntryImpl>> deleteWithResponseAsync(String topicName, String subscriptionName, String ruleName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.delete(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> deleteAsync(String topicName, String subscriptionName, String ruleName) {
        return this.deleteWithResponseAsync(topicName, subscriptionName, ruleName).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionEntryImpl> deleteAsync(String topicName, String subscriptionName, String ruleName, Context context) {
        return this.deleteWithResponseAsync(topicName, subscriptionName, ruleName, context).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionEntryImpl)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleDescriptionEntryImpl> deleteWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.deleteSync(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleDescriptionEntryImpl delete(String topicName, String subscriptionName, String ruleName) {
        return (RuleDescriptionEntryImpl)this.deleteWithResponse(topicName, subscriptionName, ruleName, Context.NONE).getValue();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    public static interface RulesService {
        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<RuleDescriptionEntryImpl>> get(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="enrich") Boolean var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<RuleDescriptionEntryImpl> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="enrich") Boolean var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<RuleDescriptionEntryImpl>> put(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @BodyParam(value="application/atom+xml") Object var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<RuleDescriptionEntryImpl> putSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @BodyParam(value="application/atom+xml") Object var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<RuleDescriptionEntryImpl>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<RuleDescriptionEntryImpl> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

