/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.messaging.servicebus.implementation.ServiceBusAmqpConnection;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusReactorAmqpConnection;
import reactor.core.publisher.Mono;

final class ConnectionCacheWrapper {
    private final boolean isV2;
    private final ReactorConnectionCache<ServiceBusReactorAmqpConnection> cache;
    private final ServiceBusConnectionProcessor processor;

    ConnectionCacheWrapper(ReactorConnectionCache<ServiceBusReactorAmqpConnection> cache) {
        this.isV2 = true;
        this.cache = cache;
        this.processor = null;
    }

    ConnectionCacheWrapper(ServiceBusConnectionProcessor processor) {
        this.isV2 = false;
        this.processor = processor;
        this.cache = null;
    }

    boolean isV2() {
        return this.isV2;
    }

    Mono<ServiceBusAmqpConnection> getConnection() {
        return this.isV2 ? this.cache.get().cast(ServiceBusAmqpConnection.class) : this.processor;
    }

    String getFullyQualifiedNamespace() {
        return this.isV2 ? this.cache.getFullyQualifiedNamespace() : this.processor.getFullyQualifiedNamespace();
    }

    AmqpRetryOptions getRetryOptions() {
        return this.isV2 ? this.cache.getRetryOptions() : this.processor.getRetryOptions();
    }

    boolean isChannelClosed() {
        return this.isV2 ? this.cache.isCurrentConnectionClosed() : this.processor.isChannelClosed();
    }
}

