/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.util.Map;

public class CertificateBundle
implements JsonSerializable<CertificateBundle> {
    private String id;
    private String kid;
    private String sid;
    private Base64Url x509Thumbprint;
    private CertificatePolicy policy;
    private byte[] cer;
    private String contentType;
    private CertificateAttributes attributes;
    private Map<String, String> tags;

    public String getId() {
        return this.id;
    }

    CertificateBundle setId(String id) {
        this.id = id;
        return this;
    }

    public String getKid() {
        return this.kid;
    }

    CertificateBundle setKid(String kid) {
        this.kid = kid;
        return this;
    }

    public String getSid() {
        return this.sid;
    }

    CertificateBundle setSid(String sid) {
        this.sid = sid;
        return this;
    }

    public byte[] getX509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    CertificateBundle setX509Thumbprint(byte[] x509Thumbprint) {
        this.x509Thumbprint = x509Thumbprint == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])x509Thumbprint));
        return this;
    }

    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    CertificateBundle setPolicy(CertificatePolicy policy) {
        this.policy = policy;
        return this;
    }

    public byte[] getCer() {
        return CoreUtils.clone((byte[])this.cer);
    }

    public CertificateBundle setCer(byte[] cer) {
        this.cer = CoreUtils.clone((byte[])cer);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public CertificateBundle setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public CertificateBundle setAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public CertificateBundle setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.cer);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateBundle)jsonReader.readObject(reader -> {
            CertificateBundle deserializedCertificateBundle = new CertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateBundle.id = reader.getString();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedCertificateBundle.kid = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedCertificateBundle.sid = reader.getString();
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedCertificateBundle.x509Thumbprint = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCertificateBundle.policy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    deserializedCertificateBundle.cer = reader.getBinary();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedCertificateBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateBundle.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCertificateBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateBundle;
        });
    }
}

