/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.util.Map;

public final class CertificateUpdateParameters
implements JsonSerializable<CertificateUpdateParameters> {
    private CertificatePolicy certificatePolicy;
    private CertificateAttributes certificateAttributes;
    private Map<String, String> tags;

    public CertificatePolicy getCertificatePolicy() {
        return this.certificatePolicy;
    }

    public CertificateUpdateParameters setCertificatePolicy(CertificatePolicy certificatePolicy) {
        this.certificatePolicy = certificatePolicy;
        return this;
    }

    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public CertificateUpdateParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public CertificateUpdateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.certificatePolicy);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CertificateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateUpdateParameters)jsonReader.readObject(reader -> {
            CertificateUpdateParameters deserializedCertificateUpdateParameters = new CertificateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedCertificateUpdateParameters.certificatePolicy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateUpdateParameters.certificateAttributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCertificateUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateUpdateParameters;
        });
    }
}

