/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.certificates;

import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.commons.codec.digest.DigestUtils;
import com.azure.security.keyvault.jca.implementation.utils.CertificateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class SpecificPathCertificates
implements AzureCertificates {
    private static final Map<String, SpecificPathCertificates> CACHE = new HashMap<String, SpecificPathCertificates>();
    private static final Logger LOGGER = Logger.getLogger(SpecificPathCertificates.class.getName());
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, Certificate> certificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate[]> certificateChains = new HashMap<String, Certificate[]>();
    private final Map<String, Key> certificateKeys = new HashMap<String, Key>();
    private final String certificatePath;

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Map<String, Certificate> getCertificates() {
        return this.certificates;
    }

    @Override
    public Map<String, Certificate[]> getCertificateChains() {
        return this.certificateChains;
    }

    @Override
    public Map<String, Key> getCertificateKeys() {
        return this.certificateKeys;
    }

    @Override
    public void deleteEntry(String alias) {
        this.aliases.remove(alias);
        this.certificates.remove(alias);
        this.certificateChains.remove(alias);
        this.certificateKeys.remove(alias);
    }

    private SpecificPathCertificates(String certificatePath) {
        this.certificatePath = certificatePath;
        this.loadCertificatesFromSpecificPath();
    }

    public void setCertificateEntry(String alias, Certificate certificate) {
        if (this.aliases.contains(alias)) {
            LOGGER.log(Level.WARNING, "Cannot load certificates with the same alias in specific path", alias);
            return;
        }
        this.aliases.add(alias);
        this.certificates.put(alias, certificate);
        this.certificateChains.put(alias, new Certificate[]{certificate});
    }

    private void setCertificateByFile(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String alias = SpecificPathCertificates.toCertificateAlias(file);
            Certificate certificate = CertificateUtil.loadX509CertificateFromFile(inputStream);
            if (certificate != null) {
                this.setCertificateEntry(alias, certificate);
                this.certificateChains.put(alias, CertificateUtil.loadX509CertificatesFromFile(inputStream));
                LOGGER.log(Level.INFO, "Load certificate from specific path. alias = {0}, thumbprint = {1}, file = {2}", new Object[]{alias, this.getThumbprint(certificate), file.getName()});
            }
        }
        catch (CertificateException e) {
            LOGGER.log(Level.WARNING, "Unable to load certificate from: " + file.getName(), e);
        }
    }

    private void loadCertificatesFromSpecificPath() {
        try {
            List<File> files = this.getFiles();
            for (File file : files) {
                this.setCertificateByFile(file);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Unable to determine certificates to specific path", ioe);
        }
    }

    String getThumbprint(Certificate certificate) {
        try {
            return DigestUtils.sha1Hex(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            LOGGER.log(Level.WARNING, "Unable to get thumbprint for certificate", e);
            return "";
        }
    }

    public static String toCertificateAlias(File file) {
        String fileName = file.getName();
        int lastIndexOfDot = fileName.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return fileName;
        }
        return fileName.substring(0, lastIndexOfDot);
    }

    private List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        File filePackage = new File(this.certificatePath);
        File[] array = filePackage.listFiles();
        Optional.ofNullable(array).map(Arrays::stream).orElseGet(Stream::empty).filter(Objects::nonNull).filter(File::isFile).filter(File::exists).filter(File::canRead).forEach(files::add);
        return files;
    }

    public static synchronized SpecificPathCertificates getSpecificPathCertificates(String path) {
        SpecificPathCertificates result = CACHE.getOrDefault(path, null);
        if (result == null) {
            result = new SpecificPathCertificates(path);
            CACHE.put(path, result);
        }
        return result;
    }
}

