/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECConstants;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECCurve;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECFieldElement;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECLookupTable;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECPoint;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec.SecP256R1Field;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec.SecP256R1FieldElement;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec.SecP256R1Point;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.raw.Nat256;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP256R1FieldElement.Q;
    private static final int SECP256R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP256R1_AFFINE_ZS = new ECFieldElement[]{new SecP256R1FieldElement(ECConstants.ONE)};
    protected SecP256R1Point infinity = new SecP256R1Point((ECCurve)this, null, null);

    public SecP256R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP256R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP256R1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP256R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat256.copy((int[])((SecP256R1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat256.copy((int[])((SecP256R1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 8));
            n3 += 8;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SecP256R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SecP256R1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP256R1_AFFINE_ZS;
    }
}

