/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.utils;

import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonProviders;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonReader;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonSerializable;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonWriter;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.ReadValueCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JsonConverterUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonConverterUtil.class.getName());

    public static <T extends JsonSerializable<T>> T fromJson(ReadValueCallback<JsonReader, T> deserializationFunction, String json) throws IOException {
        LOGGER.entering("JsonConverterUtil", "fromJson", new Object[]{deserializationFunction, json});
        try (JsonReader jsonReader = JsonProviders.createReader(json);){
            JsonSerializable deserialized = (JsonSerializable)deserializationFunction.read(jsonReader);
            LOGGER.exiting("JsonConverterUtil", "fromJson", deserialized);
            JsonSerializable jsonSerializable = deserialized;
            return (T)jsonSerializable;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toJson(JsonSerializable<?> jsonSerializable) {
        LOGGER.entering("JsonConverterUtil", "toJson", jsonSerializable);
        if (jsonSerializable == null) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string;
            block14: {
                JsonWriter jsonWriter = JsonProviders.createWriter(byteArrayOutputStream);
                try {
                    jsonWriter.writeUntyped(jsonSerializable);
                    jsonWriter.flush();
                    string = byteArrayOutputStream.toString("UTF-8");
                    if (jsonWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to convert to JSON", e);
            LOGGER.exiting("JsonConverterUtil", "toJson");
            return null;
        }
    }
}

