/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;

public final class KeyVaultKeyIdentifier {
    private final ClientLogger logger = new ClientLogger(KeyVaultKeyIdentifier.class);
    private final String sourceId;
    private final String vaultUrl;
    private final String name;
    private final String version;

    public KeyVaultKeyIdentifier(String sourceId) {
        if (sourceId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'sourceId' cannot be null."));
        }
        try {
            URL url = new URL(sourceId);
            String[] pathSegments = url.getPath().split("/");
            if (pathSegments.length != 3 && pathSegments.length != 4) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceId' is not a valid Key Vault identifier."));
            }
            this.sourceId = sourceId;
            this.vaultUrl = String.format("%s://%s", url.getProtocol(), url.getHost());
            this.name = pathSegments[2];
            this.version = pathSegments.length == 4 ? pathSegments[3] : null;
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceId' is not a valid Key Vault identifier.", e));
        }
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }
}

