/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentLinkedStorageAccountsInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccounts;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccountsPatch;
import com.azure.resourcemanager.applicationinsights.models.StorageType;

public final class ComponentLinkedStorageAccountsImpl
implements ComponentLinkedStorageAccounts,
ComponentLinkedStorageAccounts.Definition,
ComponentLinkedStorageAccounts.Update {
    private ComponentLinkedStorageAccountsInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private StorageType storageType;
    private ComponentLinkedStorageAccountsPatch updateLinkedStorageAccountsProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String linkedStorageAccount() {
        return this.innerModel().linkedStorageAccount();
    }

    @Override
    public ComponentLinkedStorageAccountsInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public ComponentLinkedStorageAccountsImpl withExistingComponent(String resourceGroupName, String resourceName) {
        this.resourceGroupName = resourceGroupName;
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ComponentLinkedStorageAccounts create() {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().createAndUpdateWithResponse(this.resourceGroupName, this.resourceName, this.storageType, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ComponentLinkedStorageAccounts create(Context context) {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().createAndUpdateWithResponse(this.resourceGroupName, this.resourceName, this.storageType, this.innerModel(), context).getValue());
        return this;
    }

    ComponentLinkedStorageAccountsImpl(StorageType name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new ComponentLinkedStorageAccountsInner();
        this.serviceManager = serviceManager;
        this.storageType = name;
    }

    @Override
    public ComponentLinkedStorageAccountsImpl update() {
        this.updateLinkedStorageAccountsProperties = new ComponentLinkedStorageAccountsPatch();
        return this;
    }

    @Override
    public ComponentLinkedStorageAccounts apply() {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().updateWithResponse(this.resourceGroupName, this.resourceName, this.storageType, this.updateLinkedStorageAccountsProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public ComponentLinkedStorageAccounts apply(Context context) {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().updateWithResponse(this.resourceGroupName, this.resourceName, this.storageType, this.updateLinkedStorageAccountsProperties, context).getValue());
        return this;
    }

    ComponentLinkedStorageAccountsImpl(ComponentLinkedStorageAccountsInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "components");
        this.storageType = StorageType.fromString(Utils.getValueFromIdByName(innerObject.id(), "linkedStorageAccounts"));
    }

    @Override
    public ComponentLinkedStorageAccounts refresh() {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().getWithResponse(this.resourceGroupName, this.resourceName, this.storageType, Context.NONE).getValue());
        return this;
    }

    @Override
    public ComponentLinkedStorageAccounts refresh(Context context) {
        this.innerObject = (ComponentLinkedStorageAccountsInner)((Object)this.serviceManager.serviceClient().getComponentLinkedStorageAccountsOperations().getWithResponse(this.resourceGroupName, this.resourceName, this.storageType, context).getValue());
        return this;
    }

    @Override
    public ComponentLinkedStorageAccountsImpl withLinkedStorageAccount(String linkedStorageAccount) {
        if (this.isInCreateMode()) {
            this.innerModel().withLinkedStorageAccount(linkedStorageAccount);
            return this;
        }
        this.updateLinkedStorageAccountsProperties.withLinkedStorageAccount(linkedStorageAccount);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

