/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeBody;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeResponse;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface ApplicationInsightsComponent {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String kind();

    public String etag();

    public String applicationId();

    public String appId();

    public String namePropertiesName();

    public ApplicationType applicationType();

    public FlowType flowType();

    public RequestSource requestSource();

    public String instrumentationKey();

    public OffsetDateTime creationDate();

    public String tenantId();

    public String hockeyAppId();

    public String hockeyAppToken();

    public String provisioningState();

    public Double samplingPercentage();

    public String connectionString();

    public Integer retentionInDays();

    public Boolean disableIpMasking();

    public Boolean immediatePurgeDataOn30Days();

    public String workspaceResourceId();

    public OffsetDateTime laMigrationDate();

    public List<PrivateLinkScopedResource> privateLinkScopedResources();

    public PublicNetworkAccessType publicNetworkAccessForIngestion();

    public PublicNetworkAccessType publicNetworkAccessForQuery();

    public IngestionMode ingestionMode();

    public Boolean disableLocalAuth();

    public Boolean forceCustomerStorageForProfiler();

    public Region region();

    public String regionName();

    public ApplicationInsightsComponentInner innerModel();

    public Update update();

    public ApplicationInsightsComponent refresh();

    public ApplicationInsightsComponent refresh(Context var1);

    public ComponentPurgeResponse purge(ComponentPurgeBody var1);

    public Response<ComponentPurgeResponse> purgeWithResponse(ComponentPurgeBody var1, Context var2);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public ApplicationInsightsComponent apply();

        public ApplicationInsightsComponent apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithForceCustomerStorageForProfiler {
            public WithCreate withForceCustomerStorageForProfiler(Boolean var1);
        }

        public static interface WithDisableLocalAuth {
            public WithCreate withDisableLocalAuth(Boolean var1);
        }

        public static interface WithIngestionMode {
            public WithCreate withIngestionMode(IngestionMode var1);
        }

        public static interface WithPublicNetworkAccessForQuery {
            public WithCreate withPublicNetworkAccessForQuery(PublicNetworkAccessType var1);
        }

        public static interface WithPublicNetworkAccessForIngestion {
            public WithCreate withPublicNetworkAccessForIngestion(PublicNetworkAccessType var1);
        }

        public static interface WithWorkspaceResourceId {
            public WithCreate withWorkspaceResourceId(String var1);
        }

        public static interface WithImmediatePurgeDataOn30Days {
            public WithCreate withImmediatePurgeDataOn30Days(Boolean var1);
        }

        public static interface WithDisableIpMasking {
            public WithCreate withDisableIpMasking(Boolean var1);
        }

        public static interface WithRetentionInDays {
            public WithCreate withRetentionInDays(Integer var1);
        }

        public static interface WithSamplingPercentage {
            public WithCreate withSamplingPercentage(Double var1);
        }

        public static interface WithHockeyAppId {
            public WithCreate withHockeyAppId(String var1);
        }

        public static interface WithRequestSource {
            public WithCreate withRequestSource(RequestSource var1);
        }

        public static interface WithFlowType {
            public WithCreate withFlowType(FlowType var1);
        }

        public static interface WithApplicationType {
            public WithCreate withApplicationType(ApplicationType var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithApplicationType,
        WithFlowType,
        WithRequestSource,
        WithHockeyAppId,
        WithSamplingPercentage,
        WithRetentionInDays,
        WithDisableIpMasking,
        WithImmediatePurgeDataOn30Days,
        WithWorkspaceResourceId,
        WithPublicNetworkAccessForIngestion,
        WithPublicNetworkAccessForQuery,
        WithIngestionMode,
        WithDisableLocalAuth,
        WithForceCustomerStorageForProfiler {
            public ApplicationInsightsComponent create();

            public ApplicationInsightsComponent create(Context var1);
        }

        public static interface WithKind {
            public WithCreate withKind(String var1);
        }

        public static interface WithResourceGroup {
            public WithKind withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithKind,
    DefinitionStages.WithCreate {
    }
}

