/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateInner;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import java.util.List;
import java.util.Map;

public interface WorkbookTemplate {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Integer priority();

    public String author();

    public Object templateData();

    public List<WorkbookTemplateGallery> galleries();

    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized();

    public Region region();

    public String regionName();

    public WorkbookTemplateInner innerModel();

    public Update update();

    public WorkbookTemplate refresh();

    public WorkbookTemplate refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithLocalized {
            public Update withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> var1);
        }

        public static interface WithGalleries {
            public Update withGalleries(List<WorkbookTemplateGallery> var1);
        }

        public static interface WithTemplateData {
            public Update withTemplateData(Object var1);
        }

        public static interface WithAuthor {
            public Update withAuthor(String var1);
        }

        public static interface WithPriority {
            public Update withPriority(Integer var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithPriority,
    UpdateStages.WithAuthor,
    UpdateStages.WithTemplateData,
    UpdateStages.WithGalleries,
    UpdateStages.WithLocalized {
        public WorkbookTemplate apply();

        public WorkbookTemplate apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithLocalized {
            public WithCreate withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> var1);
        }

        public static interface WithGalleries {
            public WithCreate withGalleries(List<WorkbookTemplateGallery> var1);
        }

        public static interface WithTemplateData {
            public WithCreate withTemplateData(Object var1);
        }

        public static interface WithAuthor {
            public WithCreate withAuthor(String var1);
        }

        public static interface WithPriority {
            public WithCreate withPriority(Integer var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithPriority,
        WithAuthor,
        WithTemplateData,
        WithGalleries,
        WithLocalized {
            public WorkbookTemplate create();

            public WorkbookTemplate create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

