/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.AppResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppDeploymentImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppDeploymentsImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppDomainsImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringAppServiceBindingsImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.AppResourceProperties;
import com.azure.resourcemanager.appplatform.models.BindingResourceProperties;
import com.azure.resourcemanager.appplatform.models.CustomDomainProperties;
import com.azure.resourcemanager.appplatform.models.ManagedIdentityProperties;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployments;
import com.azure.resourcemanager.appplatform.models.SpringAppDomains;
import com.azure.resourcemanager.appplatform.models.SpringAppServiceBindings;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.time.OffsetDateTime;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SpringAppImpl
extends ExternalChildResourceImpl<SpringApp, AppResourceInner, SpringServiceImpl, SpringService>
implements SpringApp,
SpringApp.Definition,
SpringApp.Update {
    private Creatable<SpringAppDeployment> springAppDeploymentToCreate = null;
    private final SpringAppDeploymentsImpl deployments = new SpringAppDeploymentsImpl(this);
    private final SpringAppServiceBindingsImpl serviceBindings = new SpringAppServiceBindingsImpl(this);
    private final SpringAppDomainsImpl domains = new SpringAppDomainsImpl(this);

    SpringAppImpl(String name, SpringServiceImpl parent, AppResourceInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    @Override
    public boolean isPublic() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().publicProperty();
    }

    @Override
    public boolean isHttpsOnly() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().httpsOnly();
    }

    @Override
    public String url() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().url();
    }

    @Override
    public String fqdn() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().fqdn();
    }

    @Override
    public TemporaryDisk temporaryDisk() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().temporaryDisk();
    }

    @Override
    public PersistentDisk persistentDisk() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().persistentDisk();
    }

    @Override
    public ManagedIdentityProperties identity() {
        return ((AppResourceInner)((Object)this.innerModel())).identity();
    }

    @Override
    public OffsetDateTime createdTime() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().createdTime();
    }

    @Override
    public String activeDeploymentName() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((AppResourceInner)((Object)this.innerModel())).properties().activeDeploymentName();
    }

    @Override
    public SpringAppDeployment getActiveDeployment() {
        return (SpringAppDeployment)this.getActiveDeploymentAsync().block();
    }

    @Override
    public Mono<SpringAppDeployment> getActiveDeploymentAsync() {
        String activeDeploymentName = this.activeDeploymentName();
        if (activeDeploymentName == null || activeDeploymentName.isEmpty()) {
            return Mono.empty();
        }
        return this.deployments().getByNameAsync(activeDeploymentName);
    }

    @Override
    public <T extends SpringAppDeployment.DefinitionStages.WithCreate<T>> SpringAppDeployments<T> deployments() {
        return this.deployments;
    }

    @Override
    public SpringAppServiceBindings serviceBindings() {
        return this.serviceBindings;
    }

    @Override
    public SpringAppDomains customDomains() {
        return this.domains;
    }

    @Override
    public Mono<ResourceUploadDefinition> getResourceUploadUrlAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().getResourceUploadUrlAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    @Override
    public ResourceUploadDefinition getResourceUploadUrl() {
        return (ResourceUploadDefinition)this.getResourceUploadUrlAsync().block();
    }

    private void ensureProperty() {
        if (((AppResourceInner)((Object)this.innerModel())).properties() == null) {
            ((AppResourceInner)((Object)this.innerModel())).withProperties(new AppResourceProperties());
        }
    }

    @Override
    public SpringAppImpl withDefaultPublicEndpoint() {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withPublicProperty(true);
        return this;
    }

    @Override
    public SpringAppImpl withoutDefaultPublicEndpoint() {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withPublicProperty(false);
        return this;
    }

    @Override
    public SpringAppImpl withCustomDomain(String domain) {
        this.domains.prepareCreateOrUpdate(domain, new CustomDomainProperties());
        return this;
    }

    @Override
    public SpringAppImpl withCustomDomain(String domain, String certThumbprint) {
        this.domains.prepareCreateOrUpdate(domain, new CustomDomainProperties().withThumbprint(certThumbprint));
        return this;
    }

    @Override
    public SpringApp.Update withoutCustomDomain(String domain) {
        this.domains.prepareDelete(domain);
        return this;
    }

    @Override
    public SpringAppImpl withHttpsOnly() {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withHttpsOnly(true);
        return this;
    }

    @Override
    public SpringAppImpl withoutHttpsOnly() {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withHttpsOnly(false);
        return this;
    }

    @Override
    public SpringAppImpl withTemporaryDisk(int sizeInGB, String mountPath) {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withTemporaryDisk(new TemporaryDisk().withSizeInGB(sizeInGB).withMountPath(mountPath));
        return this;
    }

    @Override
    public SpringAppImpl withPersistentDisk(int sizeInGB, String mountPath) {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withPersistentDisk(new PersistentDisk().withSizeInGB(sizeInGB).withMountPath(mountPath));
        return this;
    }

    @Override
    public SpringAppImpl withActiveDeployment(String name) {
        this.ensureProperty();
        ((AppResourceInner)((Object)this.innerModel())).properties().withActiveDeploymentName(name);
        return this;
    }

    public Mono<SpringApp> createResourceAsync() {
        if (this.springAppDeploymentToCreate == null) {
            this.withDefaultActiveDeployment();
        }
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().createOrUpdateAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name(), new AppResourceInner()).thenMany((Publisher)this.springAppDeploymentToCreate.createAsync()).then(this.updateResourceAsync());
    }

    public Mono<SpringApp> updateResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().updateAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name(), (AppResourceInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().deleteAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    protected Mono<AppResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps().getAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    public String id() {
        return ((AppResourceInner)((Object)this.innerModel())).id();
    }

    public SpringAppImpl update() {
        this.prepareUpdate();
        return this;
    }

    public AppPlatformManager manager() {
        return (AppPlatformManager)((SpringServiceImpl)this.parent()).manager();
    }

    @Override
    public SpringAppImpl withServiceBinding(String name, BindingResourceProperties bindingProperties) {
        this.serviceBindings.prepareCreateOrUpdate(name, bindingProperties);
        return this;
    }

    @Override
    public SpringAppImpl withoutServiceBinding(String name) {
        this.serviceBindings.prepareDelete(name);
        return this;
    }

    @Override
    public SpringAppImpl withDefaultActiveDeployment() {
        String defaultDeploymentName = "default";
        this.withActiveDeployment(defaultDeploymentName);
        this.springAppDeploymentToCreate = (Creatable)((SpringAppDeployment.DefinitionStages.Blank)this.deployments().define(defaultDeploymentName)).withExistingSource(UserSourceType.JAR, String.format("<%s>", defaultDeploymentName));
        return this;
    }

    @Override
    public <T extends SpringAppDeployment.DefinitionStages.WithAttach<? extends SpringApp.DefinitionStages.WithCreate, T>> SpringAppDeployment.DefinitionStages.Blank<T> defineActiveDeployment(String name) {
        return this.deployments.define(name);
    }

    SpringAppImpl addActiveDeployment(SpringAppDeploymentImpl deployment) {
        this.withActiveDeployment(deployment.name());
        this.springAppDeploymentToCreate = deployment;
        return this;
    }
}

