/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.GitPatternRepository;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ConfigServerGitProperty {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConfigServerGitProperty.class);
    @JsonProperty(value="repositories")
    private List<GitPatternRepository> repositories;
    @JsonProperty(value="uri", required=true)
    private String uri;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="searchPaths")
    private List<String> searchPaths;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="hostKey")
    private String hostKey;
    @JsonProperty(value="hostKeyAlgorithm")
    private String hostKeyAlgorithm;
    @JsonProperty(value="privateKey")
    private String privateKey;
    @JsonProperty(value="strictHostKeyChecking")
    private Boolean strictHostKeyChecking;

    public List<GitPatternRepository> repositories() {
        return this.repositories;
    }

    public ConfigServerGitProperty withRepositories(List<GitPatternRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ConfigServerGitProperty withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String label() {
        return this.label;
    }

    public ConfigServerGitProperty withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> searchPaths() {
        return this.searchPaths;
    }

    public ConfigServerGitProperty withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ConfigServerGitProperty withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ConfigServerGitProperty withPassword(String password) {
        this.password = password;
        return this;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public ConfigServerGitProperty withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public ConfigServerGitProperty withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public ConfigServerGitProperty withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public ConfigServerGitProperty withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    public void validate() {
        if (this.repositories() != null) {
            this.repositories().forEach(e -> e.validate());
        }
        if (this.uri() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property uri in model ConfigServerGitProperty"));
        }
    }
}

