/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceResourceInner;
import com.azure.resourcemanager.appplatform.models.ConfigServerGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import com.azure.resourcemanager.appplatform.models.MonitoringSettingProperties;
import com.azure.resourcemanager.appplatform.models.Sku;
import com.azure.resourcemanager.appplatform.models.SkuName;
import com.azure.resourcemanager.appplatform.models.SpringApps;
import com.azure.resourcemanager.appplatform.models.SpringServiceCertificates;
import com.azure.resourcemanager.appplatform.models.TestKeyType;
import com.azure.resourcemanager.appplatform.models.TestKeys;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import reactor.core.publisher.Mono;

public interface SpringService
extends GroupableResource<AppPlatformManager, ServiceResourceInner>,
Refreshable<SpringService>,
Updatable<Update> {
    public Sku sku();

    public SpringApps apps();

    public SpringServiceCertificates certificates();

    public MonitoringSettingProperties getMonitoringSetting();

    public Mono<MonitoringSettingProperties> getMonitoringSettingAsync();

    public ConfigServerProperties getServerProperties();

    public Mono<ConfigServerProperties> getServerPropertiesAsync();

    public TestKeys listTestKeys();

    public Mono<TestKeys> listTestKeysAsync();

    public TestKeys regenerateTestKeys(TestKeyType var1);

    public Mono<TestKeys> regenerateTestKeysAsync(TestKeyType var1);

    public void disableTestEndpoint();

    public Mono<Void> disableTestEndpointAsync();

    public TestKeys enableTestEndpoint();

    public Mono<TestKeys> enableTestEndpointAsync();

    public static interface UpdateStages {

        public static interface WithCertificate {
            public Update withCertificate(String var1, String var2, String var3);

            public Update withCertificate(String var1, String var2, String var3, String var4);

            public Update withoutCertificate(String var1);
        }

        public static interface WithConfiguration {
            public Update withGitUri(String var1);

            public Update withGitUriAndCredential(String var1, String var2, String var3);

            public Update withGitConfig(ConfigServerGitProperty var1);

            public Update withoutGitConfig();
        }

        public static interface WithTracing {
            public Update withTracing(String var1);

            public Update withoutTracing();
        }

        public static interface WithSku {
            public Update withSku(String var1);

            public Update withSku(String var1, int var2);

            public Update withSku(Sku var1);
        }
    }

    public static interface Update
    extends Appliable<SpringService>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithTracing,
    UpdateStages.WithConfiguration,
    UpdateStages.WithCertificate {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SpringService>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithTracing,
        WithConfiguration,
        WithCertificate {
        }

        public static interface WithCertificate {
            public WithCreate withCertificate(String var1, String var2, String var3);

            public WithCreate withCertificate(String var1, String var2, String var3, String var4);
        }

        public static interface WithConfiguration {
            public WithCreate withGitUri(String var1);

            public WithCreate withGitUriAndCredential(String var1, String var2, String var3);

            public WithCreate withGitConfig(ConfigServerGitProperty var1);
        }

        public static interface WithTracing {
            public WithCreate withTracing(String var1);
        }

        public static interface WithSku {
            public WithCreate withSku(String var1);

            public WithCreate withSku(SkuName var1);

            public WithCreate withSku(String var1, int var2);

            public WithCreate withSku(Sku var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

