/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BackupSchedule;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BackupRequestProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackupRequestProperties.class);
    @JsonProperty(value="backupName")
    private String backupName;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="storageAccountUrl", required=true)
    private String storageAccountUrl;
    @JsonProperty(value="backupSchedule")
    private BackupSchedule backupSchedule;
    @JsonProperty(value="databases")
    private List<DatabaseBackupSetting> databases;

    public String backupName() {
        return this.backupName;
    }

    public BackupRequestProperties withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public BackupRequestProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public BackupRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    public BackupSchedule backupSchedule() {
        return this.backupSchedule;
    }

    public BackupRequestProperties withBackupSchedule(BackupSchedule backupSchedule) {
        this.backupSchedule = backupSchedule;
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public BackupRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    public void validate() {
        if (this.storageAccountUrl() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageAccountUrl in model BackupRequestProperties"));
        }
        if (this.backupSchedule() != null) {
            this.backupSchedule().validate();
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }
}

