/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.LogSpecification;
import com.azure.resourcemanager.appservice.models.MetricSpecification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ServiceSpecification {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServiceSpecification.class);
    @JsonProperty(value="metricSpecifications")
    private List<MetricSpecification> metricSpecifications;
    @JsonProperty(value="logSpecifications")
    private List<LogSpecification> logSpecifications;

    public List<MetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public ServiceSpecification withMetricSpecifications(List<MetricSpecification> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    public List<LogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public ServiceSpecification withLogSpecifications(List<LogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public void validate() {
        if (this.metricSpecifications() != null) {
            this.metricSpecifications().forEach(e -> e.validate());
        }
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
    }
}

