/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.implementation.Utils;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.AppServiceCertificate;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateOrder;
import com.azure.resourcemanager.appservice.models.HostnameSslBinding;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.SslState;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import reactor.core.publisher.Mono;

class HostnameSslBindingImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<HostnameSslState>
implements HostnameSslBinding,
HostnameSslBinding.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
HostnameSslBinding.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private Mono<AppServiceCertificate> newCertificate;
    private AppServiceCertificateOrder.DefinitionStages.WithKeyVault certificateInDefinition;
    private final FluentImplT parent;

    HostnameSslBindingImpl(HostnameSslState inner, FluentImplT parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public String name() {
        return ((HostnameSslState)this.innerModel()).name();
    }

    @Override
    public SslState sslState() {
        return ((HostnameSslState)this.innerModel()).sslState();
    }

    @Override
    public String virtualIp() {
        return ((HostnameSslState)this.innerModel()).virtualIp();
    }

    @Override
    public String thumbprint() {
        return ((HostnameSslState)this.innerModel()).thumbprint();
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent).withNewHostNameSslBinding(this);
        return this.parent;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withPfxCertificateToUpload(File pfxFile, String password) {
        String thumbprint = this.getCertificateThumbprint(pfxFile.getPath(), password);
        this.newCertificate = ((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificates().define(this.getCertificateUniqueName(thumbprint, this.parent().region()))).withRegion(this.parent().region())).withExistingResourceGroup(this.parent().resourceGroupName())).withPfxFile(pfxFile).withPfxPassword(password).createAsync();
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withExistingCertificate(String certificateNameOrThumbprint) {
        this.newCertificate = ((AppServiceManager)((Object)this.parent().manager())).certificates().listByResourceGroupAsync(this.parent().resourceGroupName()).collectList().map(appServiceCertificates -> {
            for (AppServiceCertificate certificate : appServiceCertificates) {
                if (!certificate.name().equals(certificateNameOrThumbprint) && !certificate.thumbprint().equalsIgnoreCase(certificateNameOrThumbprint)) continue;
                return certificate;
            }
            return null;
        }).map(appServiceCertificate -> {
            if (appServiceCertificate != null) {
                this.withCertificateThumbprint(certificateNameOrThumbprint);
            }
            return appServiceCertificate;
        });
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withNewStandardSslCertificateOrder(String certificateOrderName) {
        this.certificateInDefinition = ((AppServiceCertificateOrder.DefinitionStages.WithHostName)((AppServiceCertificateOrder.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificateOrders().define(certificateOrderName)).withExistingResourceGroup(this.parent().resourceGroupName())).withHostName(this.name()).withStandardSku().withWebAppVerification(this.parent());
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withExistingAppServiceCertificateOrder(AppServiceCertificateOrder certificateOrder) {
        this.newCertificate = ((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)((AppServiceManager)((Object)this.parent().manager())).certificates().define(this.getCertificateUniqueName(certificateOrder.signedCertificate().thumbprint(), this.parent().region()))).withRegion(this.parent().region())).withExistingResourceGroup(this.parent().resourceGroupName())).withExistingCertificateOrder(certificateOrder).createAsync();
        return this;
    }

    private HostnameSslBindingImpl<FluentT, FluentImplT> withCertificateThumbprint(String thumbprint) {
        ((HostnameSslState)this.innerModel()).withThumbprint(thumbprint);
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withSniBasedSsl() {
        ((HostnameSslState)this.innerModel()).withSslState(SslState.SNI_ENABLED);
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withIpBasedSsl() {
        ((HostnameSslState)this.innerModel()).withSslState(SslState.IP_BASED_ENABLED);
        return this;
    }

    Mono<AppServiceCertificate> newCertificate() {
        return this.newCertificate.doOnNext(appServiceCertificate -> {
            if (appServiceCertificate != null) {
                this.withCertificateThumbprint(appServiceCertificate.thumbprint());
            }
        });
    }

    public WebAppBase parent() {
        return this.parent;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> forHostname(String hostname) {
        ((HostnameSslState)this.innerModel()).withName(hostname);
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withExistingKeyVault(Vault vault) {
        Mono appServiceCertificateOrderObservable = this.certificateInDefinition.withExistingKeyVault(vault).createAsync();
        AppServiceManager manager = (AppServiceManager)((Object)this.parent().manager());
        this.newCertificate = appServiceCertificateOrderObservable.flatMap(appServiceCertificateOrder -> ((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)manager.certificates().define(appServiceCertificateOrder.name())).withRegion(this.parent().regionName())).withExistingResourceGroup(this.parent().resourceGroupName())).withExistingCertificateOrder((AppServiceCertificateOrder)appServiceCertificateOrder).createAsync());
        return this;
    }

    public HostnameSslBindingImpl<FluentT, FluentImplT> withNewKeyVault(String vaultName) {
        Mono appServiceCertificateOrderObservable = this.certificateInDefinition.withNewKeyVault(vaultName, this.parent().region()).createAsync();
        AppServiceManager manager = (AppServiceManager)((Object)this.parent().manager());
        this.newCertificate = appServiceCertificateOrderObservable.flatMap(appServiceCertificateOrder -> ((AppServiceCertificate.DefinitionStages.WithCertificate)((AppServiceCertificate.DefinitionStages.WithGroup)((AppServiceCertificate.DefinitionStages.Blank)manager.certificates().define(appServiceCertificateOrder.name())).withRegion(this.parent().regionName())).withExistingResourceGroup(this.parent().resourceGroupName())).withExistingCertificateOrder((AppServiceCertificateOrder)appServiceCertificateOrder).createAsync());
        return this;
    }

    private String getCertificateThumbprint(String pfxPath, String password) {
        try {
            FileInputStream inStream = new FileInputStream(pfxPath);
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(inStream, password.toCharArray());
            String alias = ks.aliases().nextElement();
            X509Certificate certificate = (X509Certificate)ks.getCertificate(alias);
            ((InputStream)inStream).close();
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            return Utils.base16Encode(sha.digest(certificate.getEncoded()));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw this.logger.logExceptionAsError(new RuntimeException(ex));
        }
    }

    private String getCertificateUniqueName(String thumbprint, Region region) {
        return String.format("%s##%s#", thumbprint, region.label());
    }
}

