// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainInner;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CustomDomainsClient. */
public interface CustomDomainsClient {
    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CustomDomainInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName);

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CustomDomainInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName);

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CustomDomainInner> listByEndpoint(
        String resourceGroupName, String profileName, String endpointName, Context context);

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing custom domain within an endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomDomainInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing custom domain within an endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> getAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing custom domain within an endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner get(String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing custom domain within an endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomDomainInner> getWithResponse(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostname);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginCreateAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostname);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginCreate(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostname);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String endpointName,
        String customDomainName,
        String hostname,
        Context context);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> createAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostname);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> createAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner create(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostname);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner create(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner create(
        String resourceGroupName,
        String profileName,
        String endpointName,
        String customDomainName,
        String hostname,
        Context context);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<CustomDomainInner>, CustomDomainInner> beginDeleteAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDelete(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<CustomDomainInner>, CustomDomainInner> beginDelete(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> deleteAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner delete(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner delete(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context);

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomDomainInner>> disableCustomHttpsWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> disableCustomHttpsAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner disableCustomHttps(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomDomainInner> disableCustomHttpsWithResponse(
        String resourceGroupName, String profileName, String endpointName, String customDomainName, Context context);

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The JSON object that contains the properties to secure a custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomDomainInner>> enableCustomHttpsWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        String customDomainName,
        CustomDomainHttpsParameters customDomainHttpsParameters);

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The JSON object that contains the properties to secure a custom domain.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> enableCustomHttpsAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        String customDomainName,
        CustomDomainHttpsParameters customDomainHttpsParameters);

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomDomainInner> enableCustomHttpsAsync(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomDomainInner enableCustomHttps(
        String resourceGroupName, String profileName, String endpointName, String customDomainName);

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The JSON object that contains the properties to secure a custom domain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomDomainInner> enableCustomHttpsWithResponse(
        String resourceGroupName,
        String profileName,
        String endpointName,
        String customDomainName,
        CustomDomainHttpsParameters customDomainHttpsParameters,
        Context context);
}
